/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.tests.issues.IssueMatcher;
import org.eclipse.xtext.validation.Issue;

public class IssueExpectations {
    private final Collection<IssueMatcher> issueMatchers = new LinkedList<IssueMatcher>();
    private boolean inverted = false;

    public void invert() {
        this.inverted = !this.inverted;
    }

    public IssueMatcher add() {
        IssueMatcher issueMatcher = new IssueMatcher();
        this.issueMatchers.add(issueMatcher);
        return issueMatcher;
    }

    public boolean matchesExactly(Collection<Issue> issues, List<String> messages) {
        LinkedList<Issue> issueCopy = new LinkedList<Issue>(issues);
        LinkedList<IssueMatcher> matcherCopy = new LinkedList<IssueMatcher>(this.issueMatchers);
        this.performMatching(issueCopy, matcherCopy, messages);
        if (this.inverted) {
            if (issueCopy.isEmpty() && matcherCopy.isEmpty()) {
                if (this.issueMatchers.isEmpty() && messages != null) {
                    messages.add("Expected issues, but got nothing");
                } else {
                    this.explainIssues(issues, messages, this.inverted);
                    this.explainExpectations(this.issueMatchers, messages, this.inverted);
                }
                return false;
            }
        } else if (!issueCopy.isEmpty() || !matcherCopy.isEmpty()) {
            this.explainIssues(issueCopy, messages, this.inverted);
            this.explainExpectations(matcherCopy, messages, this.inverted);
            return false;
        }
        return true;
    }

    public boolean matchesAllExpectations(Collection<Issue> issues, List<String> messages) {
        LinkedList<Issue> issueCopy = new LinkedList<Issue>(issues);
        LinkedList<IssueMatcher> matcherCopy = new LinkedList<IssueMatcher>(this.issueMatchers);
        this.performMatching(issueCopy, matcherCopy, messages);
        if (this.inverted) {
            if (matcherCopy.isEmpty()) {
                this.explainExpectations(this.issueMatchers, messages, this.inverted);
                return false;
            }
        } else if (!matcherCopy.isEmpty()) {
            this.explainExpectations(matcherCopy, messages, this.inverted);
            return false;
        }
        return false;
    }

    public boolean matchesAllIssues(Collection<Issue> issues, List<String> messages) {
        LinkedList<Issue> issueCopy = new LinkedList<Issue>(issues);
        LinkedList<IssueMatcher> matcherCopy = new LinkedList<IssueMatcher>(this.issueMatchers);
        this.performMatching(issueCopy, matcherCopy, messages);
        if (this.inverted) {
            if (issueCopy.isEmpty()) {
                this.explainIssues(issues, messages, this.inverted);
                return false;
            }
        } else if (!issueCopy.isEmpty()) {
            this.explainIssues(issueCopy, messages, this.inverted);
            return false;
        }
        return true;
    }

    private void explainIssues(Collection<Issue> unmatchedIssues, List<String> messages, boolean expected) {
        if (messages != null) {
            for (Issue issue : unmatchedIssues) {
                messages.add(String.valueOf(expected ? "Expected issue: " : "Unexpected issue: ") + issue);
            }
        }
    }

    private void explainExpectations(Collection<IssueMatcher> unmatchedMatchers, List<String> messages, boolean expected) {
        if (messages != null) {
            for (IssueMatcher matcher : unmatchedMatchers) {
                messages.add(String.valueOf(expected ? "Unexpectedly matched" : "Unmatched ") + " expectation: " + matcher.getDescription());
            }
        }
    }

    private void performMatching(Collection<Issue> issues, Collection<IssueMatcher> matchers, List<String> messages) {
        Iterator<Issue> issueIt = issues.iterator();
        block0: while (issueIt.hasNext() && !matchers.isEmpty()) {
            Issue issue = issueIt.next();
            Iterator<IssueMatcher> matcherIt = matchers.iterator();
            while (matcherIt.hasNext()) {
                IssueMatcher matcher = matcherIt.next();
                if (matcher.matches(issue)) {
                    issueIt.remove();
                    matcherIt.remove();
                    continue block0;
                }
                if (messages == null) continue;
                messages.addAll(matcher.explainMismatch(issue));
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.inverted) {
            result.append("Issues expected NOT to match:\n");
        } else {
            result.append("Issues expected to match:\n");
        }
        for (IssueMatcher matcher : this.issueMatchers) {
            result.append("    ").append(matcher.toString()).append("\n");
        }
        return result.toString();
    }
}

