/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.xtext.builder.impl.ToBeBuilt;

@Singleton
public class OutdatedPackageJsonQueue {
    private final Deque<Task> internalQueue = new ConcurrentLinkedDeque<Task>();

    protected void enqueue(Set<String> projectNames, ToBeBuilt toBeBuilt, boolean forcedIndexSync) {
        this.internalQueue.addLast(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt, forcedIndexSync));
    }

    protected void insert(Set<String> projectNames, ToBeBuilt toBeBuilt, boolean forcedIndexSync) {
        this.internalQueue.addFirst(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt, forcedIndexSync));
    }

    public Task exhaust() {
        LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
        ToBeBuilt toBeBuilt = new ToBeBuilt();
        Set toBeUpdated = toBeBuilt.getToBeUpdated();
        boolean forcedIndexSync = false;
        Task next = this.internalQueue.poll();
        while (next != null) {
            Set nextToBeUpdated = next.toBeBuilt.getToBeUpdated();
            if (next.forcedIndexSync) {
                forcedIndexSync = true;
            }
            if (nextToBeUpdated != null && !nextToBeUpdated.isEmpty()) {
                projectNames.addAll((Collection<String>)next.projectNames);
                toBeUpdated.addAll(nextToBeUpdated);
            }
            next = this.internalQueue.poll();
        }
        return new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt, forcedIndexSync);
    }

    public class Task {
        private final ImmutableSet<String> projectNames;
        private final ToBeBuilt toBeBuilt;
        private final boolean forcedIndexSync;

        protected Task(ImmutableSet<String> projectNames, ToBeBuilt toBeBuilt, boolean forcedIndexSync) {
            this.projectNames = projectNames;
            this.toBeBuilt = toBeBuilt;
            this.forcedIndexSync = forcedIndexSync;
        }

        public boolean isEmpty() {
            return this.toBeBuilt.getToBeUpdated().isEmpty() && !this.forcedIndexSync;
        }

        public void reschedule() {
            Set toBeUpdated = this.toBeBuilt.getToBeUpdated();
            if (toBeUpdated != null && !toBeUpdated.isEmpty()) {
                ToBeBuilt scheduleMe = new ToBeBuilt();
                scheduleMe.getToBeUpdated().addAll(toBeUpdated);
                OutdatedPackageJsonQueue.this.insert((Set<String>)this.projectNames, scheduleMe, this.forcedIndexSync);
            }
        }

        public ImmutableSet<String> getProjectNames() {
            return this.projectNames;
        }

        public ToBeBuilt getToBeBuilt() {
            return this.toBeBuilt;
        }
    }
}

