/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ASTIterator;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyser;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyserDataRecorder;
import org.eclipse.n4js.flowgraphs.analysers.AllBranchPrintVisitor;
import org.eclipse.n4js.flowgraphs.analysers.AllNodesAndEdgesPrintVisitor;
import org.eclipse.n4js.flowgraphs.analysers.DummyBackwardVisitor;
import org.eclipse.n4js.flowgraphs.analysers.DummyForwardVisitor;
import org.eclipse.n4js.flowgraphs.analysers.InstanceofGuardAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.guards.InstanceofGuard;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.n4js.xpect.methods.scoping.IN4JSCommaSeparatedValuesExpectation;
import org.eclipse.n4js.xpect.methods.scoping.N4JSCommaSeparatedValuesExpectation;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

@XpectImport(value={N4JSOffsetAdapter.class})
public class FlowgraphsXpectMethod {
    N4JSFlowAnalyser createFlowAnalyzer(EObject eo) {
        Script script = (Script)EcoreUtil2.getContainerOfType((EObject)eo, Script.class);
        N4JSFlowAnalyser flowAnalyzer = new N4JSFlowAnalyser();
        flowAnalyzer.createGraphs(script);
        return flowAnalyzer;
    }

    @ParameterParser(syntax="('of' arg2=OFFSET)?")
    @Xpect
    public void astOrder(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        EObject context = offset.getEObject();
        ASTIterator astIter = new ASTIterator(context);
        int idx = 0;
        LinkedList<String> astElements = new LinkedList<String>();
        while (astIter.hasNext()) {
            ControlFlowElement cfe = (ControlFlowElement)astIter.next();
            String elem = String.valueOf(idx) + ": " + FGUtils.getSourceText((EObject)cfe);
            astElements.add(elem);
            ++idx;
        }
        expectation.assertEquals(astElements);
    }

    @ParameterParser(syntax="('type' arg1=STRING)? ('at' arg2=OFFSET)?")
    @Xpect
    public void preds(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, String type, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        ControlFlowType cfType = this.getControlFlowType(type);
        ControlFlowElement cfe = this.getCFE(offset);
        Set preds = this.createFlowAnalyzer((EObject)cfe).getPredecessorsSkipInternal(cfe);
        this.filterByControlFlowType(cfe, preds, cfType);
        LinkedList<String> predTexts = new LinkedList<String>();
        for (ControlFlowElement succ : preds) {
            String predText = FGUtils.getSourceText((EObject)succ);
            predTexts.add(predText);
        }
        expectation.assertEquals(predTexts);
    }

    @ParameterParser(syntax="('type' arg1=STRING)? ('at' arg2=OFFSET)?")
    @Xpect
    public void succs(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, String type, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        ControlFlowType cfType = this.getControlFlowType(type);
        ControlFlowElement cfe = this.getCFE(offset);
        Set succs = this.createFlowAnalyzer((EObject)cfe).getSuccessorsSkipInternal(cfe);
        this.filterByControlFlowType(cfe, succs, cfType);
        LinkedList<String> succTexts = new LinkedList<String>();
        for (ControlFlowElement succ : succs) {
            String succText = FGUtils.getSourceText((EObject)succ);
            succTexts.add(succText);
        }
        expectation.assertEquals(succTexts);
    }

    private ControlFlowType getControlFlowType(String type) {
        ControlFlowType cfType = null;
        if (type != null && !type.isEmpty() && (cfType = ControlFlowType.valueOf((String)type)) == null) {
            Assert.fail((String)("Type '" + type + "' is not a control flow type"));
            return null;
        }
        return cfType;
    }

    private void filterByControlFlowType(ControlFlowElement start, Collection<ControlFlowElement> succList, ControlFlowType cfType) {
        if (cfType == null) {
            return;
        }
        Iterator<ControlFlowElement> succIt = succList.iterator();
        while (succIt.hasNext()) {
            N4JSFlowAnalyser flowAnalyzer = this.createFlowAnalyzer((EObject)start);
            TreeSet currCFTypes = flowAnalyzer.getControlFlowTypeToSuccessors(start, succIt.next());
            if (currCFTypes.contains(cfType)) continue;
            succIt.remove();
        }
    }

    @ParameterParser(syntax="'from' arg0=OFFSET ('to' arg1=OFFSET)? ('notTo' arg2=OFFSET)? ('via' arg3=OFFSET)? ('notVia' arg4=OFFSET)? ('pleaseNeverUseThisParameterSinceItExistsOnlyToGetAReferenceOffset' arg5=OFFSET)?")
    @Xpect
    public void path(N4JSOffsetAdapter.IEObjectCoveringRegion fromOffset, N4JSOffsetAdapter.IEObjectCoveringRegion toOffset, N4JSOffsetAdapter.IEObjectCoveringRegion notToOffset, N4JSOffsetAdapter.IEObjectCoveringRegion viaOffset, N4JSOffsetAdapter.IEObjectCoveringRegion notViaOffset, N4JSOffsetAdapter.IEObjectCoveringRegion referenceOffset) {
        boolean actualPathExists;
        boolean expectPathExists;
        N4JSOffsetAdapter.EObjectCoveringRegion toOffsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)toOffset;
        N4JSOffsetAdapter.EObjectCoveringRegion notToOffsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)notToOffset;
        N4JSOffsetAdapter.EObjectCoveringRegion viaOffsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)viaOffset;
        N4JSOffsetAdapter.EObjectCoveringRegion notViaOffsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)notViaOffset;
        N4JSOffsetAdapter.EObjectCoveringRegion referenceOffsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)referenceOffset;
        ControlFlowElement fromCFE = this.getCFE(fromOffset);
        ControlFlowElement toCFE = this.getCFEWithReference(toOffsetImpl, referenceOffsetImpl);
        ControlFlowElement notToCFE = this.getCFEWithReference(notToOffsetImpl, referenceOffsetImpl);
        ControlFlowElement viaCFE = this.getCFEWithReference(viaOffsetImpl, referenceOffsetImpl);
        ControlFlowElement notViaCFE = this.getCFEWithReference(notViaOffsetImpl, referenceOffsetImpl);
        ControlFlowElement targetCFE = toCFE != null ? toCFE : notToCFE;
        boolean bl = expectPathExists = toCFE != null;
        if (fromCFE == null) {
            Assert.fail((String)"Element 'from' could not be found");
        }
        if (targetCFE == null) {
            Assert.fail((String)"Element 'to' or 'notTo' could not be found or before 'from'");
        }
        if (viaCFE != null) {
            actualPathExists = this.createFlowAnalyzer((EObject)fromCFE).isTransitiveSuccessor(fromCFE, viaCFE, notViaCFE);
            actualPathExists &= this.createFlowAnalyzer((EObject)fromCFE).isTransitiveSuccessor(viaCFE, targetCFE, notViaCFE);
        } else {
            actualPathExists = this.createFlowAnalyzer((EObject)fromCFE).isTransitiveSuccessor(fromCFE, targetCFE, notViaCFE);
        }
        if (expectPathExists && !actualPathExists) {
            Assert.fail((String)"Path not found");
        }
        if (!expectPathExists && actualPathExists) {
            Assert.fail((String)"A path was found");
        }
    }

    private ControlFlowElement getCFEWithReference(N4JSOffsetAdapter.EObjectCoveringRegion offset, N4JSOffsetAdapter.EObjectCoveringRegion reference) {
        ControlFlowElement cfe = null;
        if (reference.getOffset() < offset.getOffset()) {
            cfe = this.getCFE(offset);
        }
        return cfe;
    }

    @ParameterParser(syntax="('pleaseNeverUseThisParameterSinceItExistsOnlyToGetAReferenceOffset' arg1=OFFSET)?")
    @Xpect
    public void allMergeBranches(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion referenceOffset) {
        N4JSFlowAnalyserDataRecorder.setEnabled((boolean)true);
        DummyForwardVisitor dfv = new DummyForwardVisitor();
        DummyBackwardVisitor dbv = new DummyBackwardVisitor();
        ControlFlowElement referenceCFE = this.getCFE(referenceOffset);
        this.createFlowAnalyzer((EObject)referenceCFE).accept(new FlowAnalyser[]{dfv, dbv});
        N4JSFlowAnalyserDataRecorder.setEnabled((boolean)false);
        this.performBranchAnalysis(referenceOffset, null, referenceOffset);
        LinkedList<String> edgeStrings = new LinkedList<String>();
        int groupIdx = 0;
        List mergedEdges = N4JSFlowAnalyserDataRecorder.getMergedEdges();
        for (Pair pair : mergedEdges) {
            Node startNode = (Node)pair.getKey();
            List edges = (List)pair.getValue();
            for (ControlFlowEdge edge : edges) {
                String c = edge.start == startNode ? "B" : "F";
                edgeStrings.add(String.valueOf(c) + groupIdx + ": " + edge.toString());
            }
            ++groupIdx;
        }
        Collections.sort(edgeStrings);
        expectation.assertEquals(edgeStrings);
    }

    @ParameterParser(syntax="('from' arg1=OFFSET)? ('direction' arg2=STRING)? ('pleaseNeverUseThisParameterSinceItExistsOnlyToGetAReferenceOffset' arg3=OFFSET)?")
    @Xpect
    public void allBranches(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset, String directionName, N4JSOffsetAdapter.IEObjectCoveringRegion referenceOffset) {
        AllBranchPrintVisitor appw = this.performBranchAnalysis(offset, directionName, referenceOffset);
        List branchStrings = appw.getBranchStrings();
        expectation.assertEquals(branchStrings);
    }

    @ParameterParser(syntax="('from' arg1=OFFSET)? ('direction' arg2=STRING)? ('pleaseNeverUseThisParameterSinceItExistsOnlyToGetAReferenceOffset' arg3=OFFSET)?")
    @Xpect
    public void allPaths(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset, String directionName, N4JSOffsetAdapter.IEObjectCoveringRegion referenceOffset) {
        AllBranchPrintVisitor appw = this.performBranchAnalysis(offset, directionName, referenceOffset);
        List pathStrings = appw.getPathStrings();
        expectation.assertEquals(pathStrings);
    }

    private AllBranchPrintVisitor performBranchAnalysis(N4JSOffsetAdapter.IEObjectCoveringRegion offset, String directionName, N4JSOffsetAdapter.IEObjectCoveringRegion referenceOffset) {
        N4JSOffsetAdapter.EObjectCoveringRegion offsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)offset;
        N4JSOffsetAdapter.EObjectCoveringRegion referenceOffsetImpl = (N4JSOffsetAdapter.EObjectCoveringRegion)referenceOffset;
        ControlFlowElement startCFE = this.getCFEWithReference(offsetImpl, referenceOffsetImpl);
        ControlFlowElement referenceCFE = this.getCFE(referenceOffset);
        TraverseDirection direction = this.getDirection(directionName);
        ControlFlowElement container = FGUtils.getCFContainer((ControlFlowElement)referenceCFE);
        AllBranchPrintVisitor appw = new AllBranchPrintVisitor(container, startCFE, direction);
        this.createFlowAnalyzer((EObject)referenceCFE).accept(new FlowAnalyser[]{appw});
        return appw;
    }

    private TraverseDirection getDirection(String directionName) {
        TraverseDirection direction = TraverseDirection.Forward;
        if (directionName != null && !directionName.isEmpty() && (direction = TraverseDirection.valueOf((String)directionName)) == null) {
            Assert.fail((String)"Unknown direction");
        }
        return direction;
    }

    @ParameterParser(syntax="('from' arg1=OFFSET)?")
    @Xpect
    public void allEdges(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        ControlFlowElement cfe = null;
        if (offset != null) {
            cfe = this.getCFE(offset);
        }
        cfe = FGUtils.getCFContainer(cfe);
        AllNodesAndEdgesPrintVisitor anaepw = new AllNodesAndEdgesPrintVisitor(cfe);
        this.createFlowAnalyzer((EObject)cfe).accept(new FlowAnalyser[]{anaepw});
        List pathStrings = anaepw.getAllEdgeStrings();
        expectation.assertEquals(pathStrings);
    }

    @ParameterParser(syntax="'of' arg1=OFFSET 'and' arg2=OFFSET")
    @Xpect
    public void commonPreds(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion a, N4JSOffsetAdapter.IEObjectCoveringRegion b) {
        ControlFlowElement aCFE = this.getCFE(a);
        ControlFlowElement bCFE = this.getCFE(b);
        Set commonPreds = this.createFlowAnalyzer((EObject)aCFE).getCommonPredecessors(aCFE, bCFE);
        LinkedList<String> commonPredStrs = new LinkedList<String>();
        for (ControlFlowElement commonPred : commonPreds) {
            String commonPredStr = FGUtils.getSourceText((EObject)commonPred);
            commonPredStrs.add(commonPredStr);
        }
        expectation.assertEquals(commonPredStrs);
    }

    private ControlFlowElement getCFE(N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        EObject context = offset.getEObject();
        if (!(context instanceof ControlFlowElement)) {
            Assert.fail((String)("Element '" + FGUtils.getSourceText((EObject)context) + "' is not a control flow element"));
        }
        ControlFlowElement cfe = (ControlFlowElement)context;
        return cfe;
    }

    @ParameterParser(syntax="('of' arg1=OFFSET)?")
    @Xpect
    public void cfContainer(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        ControlFlowElement cfe = this.getCFE(offset);
        ControlFlowElement container = this.createFlowAnalyzer((EObject)cfe).getContainer(cfe);
        EObject containerContainer = container.eContainer();
        String ccString = containerContainer != null ? String.valueOf(FGUtils.getClassName((EObject)containerContainer)) + "::" : "";
        String containerStr = String.valueOf(ccString) + FGUtils.getClassName((EObject)container);
        expectation.assertEquals((Object)containerStr);
    }

    @ParameterParser(syntax="('of' arg1=OFFSET)?")
    @Xpect
    public void instanceofguard(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        ControlFlowElement cfe = this.getCFE(offset);
        InstanceofGuardAnalyser iga = new InstanceofGuardAnalyser();
        N4JSFlowAnalyser flowAnalyzer = this.createFlowAnalyzer((EObject)cfe);
        flowAnalyzer.accept(new FlowAnalyser[]{iga});
        Collection ioGuards = iga.getAlwaysHoldingTypes(cfe);
        LinkedList<String> commonPredStrs = new LinkedList<String>();
        for (InstanceofGuard ioGuard : ioGuards) {
            String symbolText = FGUtils.getSourceText((EObject)ioGuard.symbolCFE);
            String typeText = FGUtils.getSourceText((EObject)ioGuard.typeIdentifier);
            commonPredStrs.add(String.valueOf(symbolText) + "<:" + typeText);
        }
        expectation.assertEquals(commonPredStrs);
    }
}

