/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.eclipse.n4js.utils.UtilN4;

public final class Result {
    private final boolean success;
    private final String failureMessage;
    private final boolean priority;
    private final Result cause;

    private Result() {
        this.success = true;
        this.failureMessage = null;
        this.priority = false;
        this.cause = null;
    }

    private Result(String failureMessage, boolean priority, Result cause) {
        this.success = false;
        this.failureMessage = failureMessage;
        this.priority = priority;
        this.cause = cause;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public Result getCause() {
        return this.cause;
    }

    public boolean isOrIsCausedByPriority() {
        return this.getPriorityFailure() != null;
    }

    public Result getPriorityFailure() {
        if (!this.success && this.priority) {
            return this;
        }
        if (this.cause != null) {
            return this.cause.getPriorityFailure();
        }
        return null;
    }

    public String getPriorityFailureMessage() {
        Result priorityFailure = this.getPriorityFailure();
        String priorityMessage = priorityFailure != null ? priorityFailure.getFailureMessage() : null;
        return priorityMessage != null ? priorityMessage : this.failureMessage;
    }

    public String getCompiledFailureMessage() {
        ArrayList<String> prioMsgs = new ArrayList<String>();
        Result curr = this;
        while (curr != null) {
            String currMsg;
            if (curr.isFailure() && curr.isPriority() && (currMsg = curr.getFailureMessage()) != null) {
                prioMsgs.add(Result.prepareMessage(currMsg));
            }
            curr = curr.getCause();
        }
        return !prioMsgs.isEmpty() ? Joiner.on((String)"\nCaused by:\n").join(prioMsgs) : Result.prepareMessage(this.getFailureMessage());
    }

    private static final String prepareMessage(String message) {
        if (message == null) {
            return null;
        }
        String result = message;
        if (!(result = UtilN4.trimPrefix((String)result, (String[])new String[]{"failed: "})).endsWith(".")) {
            result = String.valueOf(result) + ".";
        }
        return result;
    }

    public Result setDefaultFailureMessage(String newFailureMessage) {
        if (!this.isFailure()) {
            return this;
        }
        return this.getFailureMessage() == null ? new Result(newFailureMessage, this.priority, this.cause) : new Result(newFailureMessage, false, this);
    }

    public Result trimCauses() {
        return this.isFailure() && this.getCause() != null ? new Result(this.failureMessage, this.priority, null) : this;
    }

    public static Result success() {
        return new Result();
    }

    public static Result failure(String failureMessage, boolean priority, Result cause) {
        return new Result(failureMessage, priority, cause);
    }
}

