/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.smith.ui.graph.ColorUtils;
import org.eclipse.n4js.smith.ui.graph.VisualisationNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class ChartNode
extends VisualisationNode {
    protected String title;
    protected String description;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected ChartNode parent;
    protected final List<ChartNode> children = new ArrayList<ChartNode>();
    private final List<Long> data;
    private final float totalScale;
    final Float dataMin;
    final Float dataMax;
    final float chartHeight;
    final float chartWidth;
    final int dataStart;
    final int dataEnd;
    final int dataSize;

    public ChartNode(String title, String description, List<Long> data, float totalScale, Float dataMin, Float dataMax, float chartHeight, float chartWidth, int dataStart, int dataEnd, int dataSize) {
        this.title = title;
        this.description = description;
        this.data = data;
        this.totalScale = totalScale;
        this.dataMin = dataMin;
        this.dataMax = dataMax;
        this.chartHeight = chartHeight;
        this.chartWidth = chartWidth;
        this.dataStart = dataStart;
        this.dataEnd = dataEnd;
        this.dataSize = dataSize;
    }

    public void setParent(ChartNode parent) {
        this.parent = parent;
    }

    public void addChild(ChartNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    int getDepth() {
        int d = 0;
        ChartNode node = this;
        while (node.parent != null) {
            ++d;
            node = node.parent;
        }
        return d;
    }

    @Override
    public void paint(GC gc) {
        Color oldBackground = gc.getBackground();
        Color oldForeground = gc.getForeground();
        try {
            long value = -1L;
            int coordinatesSize = 2 * (this.dataEnd - this.dataStart + 2);
            int[] coordinates = new int[coordinatesSize];
            coordinates[0] = (int)(ChartNode.linearScale(this.dataStart, 0.0f, this.dataSize) * this.chartWidth);
            coordinates[1] = 0;
            int j = this.dataStart;
            while (j < this.dataEnd) {
                int pointY;
                int pointX;
                int jj = j - this.dataStart;
                int s = (jj + 1) * 2;
                value = this.data.get(jj);
                coordinates[s] = pointX = (int)(ChartNode.linearScale(j, 0.0f, this.dataSize) * this.chartWidth);
                coordinates[s + 1] = pointY = (int)(ChartNode.logScale(value, this.dataMin.floatValue(), this.dataMax.floatValue()) * this.chartHeight);
                ++j;
            }
            coordinates[coordinatesSize - 2] = coordinates[coordinatesSize - 4];
            coordinates[coordinatesSize - 1] = 0;
            gc.setBackground(ChartNode.getColor(this.totalScale));
            gc.setForeground(gc.getDevice().getSystemColor(2));
            gc.fillPolygon(coordinates);
        }
        finally {
            gc.setBackground(oldBackground);
            gc.setForeground(oldForeground);
        }
    }

    private static Color getColor(float volumePercentage) {
        float factor = volumePercentage;
        RGB color = new RGB(255, ColorUtils.clamp(255.0f * factor), ColorUtils.clamp(255.0f * factor));
        return ColorUtils.getColor(color);
    }

    public static float logScale(float valueIn, float minData, float maxData) {
        float logScale = (float)((Math.log10(valueIn) - Math.log10(minData)) / (Math.log10(maxData) - Math.log10(minData)));
        return logScale;
    }

    public static float linearScale(float valueIn, float minData, float maxData) {
        float linearScale = (valueIn - minData) / (maxData - minData);
        return linearScale;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<VisualisationNode> getChildren() {
        return new LinkedList<VisualisationNode>(this.children);
    }

    @Override
    public void sortChildren(Comparator<VisualisationNode> cmp) {
        this.children.sort(cmp);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

