/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.constraints.TypeConstraint;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class WildcardCaptureTestHelper {
    public List<List<TypeConstraint>> createCaptureVariationsForConstraints(RuleEnvironment G, Collection<TypeConstraint> constraints, boolean avoidClosedCaptures) {
        Functions.Function1 _function = it -> Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{it.left, it.right, it.variance}));
        List constraintsAsSingleListOfObjects = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(constraints, (Functions.Function1)_function));
        List variations = this.createCaptureVariations(G, constraintsAsSingleListOfObjects, avoidClosedCaptures);
        Functions.Function1 _function_1 = it -> {
            ArrayList result = CollectionLiterals.newArrayList();
            Iterator iter = it.iterator();
            while (iter.hasNext()) {
                Object _next = iter.next();
                Object _next_1 = iter.next();
                Object _next_2 = iter.next();
                TypeConstraint _typeConstraint = new TypeConstraint((TypeArgument)_next, (TypeArgument)_next_1, (Variance)_next_2);
                result.add(_typeConstraint);
            }
            return result;
        };
        List listOfListOfConstraints = IterableExtensions.toList((Iterable)ListExtensions.map(variations, (Functions.Function1)_function_1));
        return listOfListOfConstraints;
    }

    public <T> List<List<T>> createCaptureVariations(RuleEnvironment G, Collection<T> objects) {
        return this.createCaptureVariations(G, objects, false);
    }

    public <T> List<List<T>> createCaptureVariations(RuleEnvironment G, Collection<T> objects, boolean avoidClosedCaptures) {
        int _xifexpression = 0;
        _xifexpression = avoidClosedCaptures ? 2 : 3;
        int numOfVariationsPerWildcard = _xifexpression;
        int numOfWildcards = ((Object[])Conversions.unwrapArray((Object)Iterables.filter(objects, Wildcard.class), Object.class)).length;
        long numOfTotalVariations = Math.round(Math.pow(numOfVariationsPerWildcard, numOfWildcards));
        ArrayList result = CollectionLiterals.newArrayList();
        UtilN4.DigitIterator iter = new UtilN4.DigitIterator(0, numOfVariationsPerWildcard);
        while ((long)iter.getValue() < numOfTotalVariations) {
            ArrayList variation = Lists.newArrayList(this.createCaptureVariation(G, objects, iter, avoidClosedCaptures));
            result.add(variation);
            iter.inc();
        }
        return result;
    }

    private <T> Iterable<T> createCaptureVariation(RuleEnvironment G, Iterable<T> objects, UtilN4.DigitIterator iter, boolean avoidClosedCaptures) {
        Functions.Function1 _function = obj -> {
            Object _xifexpression = null;
            if (obj instanceof Wildcard) {
                Object _xblockexpression = null;
                int digit = iter.nextDigit();
                Object _xifexpression_1 = null;
                if (digit == 0) {
                    _xifexpression_1 = obj;
                } else {
                    TypeRef _captureAndReopen;
                    TypeRef _capture;
                    TypeRef _xifexpression_2 = null;
                    _xifexpression_2 = digit == 1 && !avoidClosedCaptures ? (_capture = this.capture((Wildcard)obj)) : (_captureAndReopen = this.captureAndReopen(G, (Wildcard)obj));
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xblockexpression = _xifexpression_1;
            } else {
                _xifexpression = obj;
            }
            return _xifexpression;
        };
        return IterableExtensions.map(objects, (Functions.Function1)_function);
    }

    public TypeRef capture(Wildcard wildcard) {
        ExistentialTypeRef captured = TypeUtils.captureWildcard((Wildcard)wildcard);
        return captured;
    }

    public TypeRef captureAndReopen(RuleEnvironment G, Wildcard wildcard) {
        TypeRef captured = this.capture(wildcard);
        TypeRef reopened = this.reopenExistentialTypes(G, captured);
        return reopened;
    }

    public TypeRef reopenExistentialTypes(RuleEnvironment G, TypeRef typeRef) {
        TypeArgument _reopenExistentialTypes = this.reopenExistentialTypes(G, (TypeArgument)typeRef);
        return (TypeRef)_reopenExistentialTypes;
    }

    public TypeArgument reopenExistentialTypes(RuleEnvironment G, TypeArgument typeArg) {
        boolean isOrContainsClosedExistential;
        boolean bl = isOrContainsClosedExistential = WildcardCaptureTestHelper.isClosedExistentialTypeRef((EObject)typeArg) || IteratorExtensions.exists((Iterator)typeArg.eAllContents(), it -> WildcardCaptureTestHelper.isClosedExistentialTypeRef(it));
        if (isOrContainsClosedExistential) {
            TypeArgument cpy = (TypeArgument)TypeUtils.copy((EObject)typeArg);
            if (cpy instanceof ExistentialTypeRef) {
                ((ExistentialTypeRef)cpy).setReopened(true);
            }
            Procedures.Procedure1 _function = it -> it.setReopened(true);
            IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)cpy.eAllContents(), ExistentialTypeRef.class), (Procedures.Procedure1)_function);
            return cpy;
        }
        return typeArg;
    }

    private static boolean isClosedExistentialTypeRef(EObject eObj) {
        boolean _isReopened;
        boolean _xifexpression = false;
        _xifexpression = eObj instanceof ExistentialTypeRef ? !(_isReopened = ((ExistentialTypeRef)eObj).isReopened()) : false;
        return _xifexpression;
    }
}

