/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.analysis;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.analysis.Analyser;
import org.eclipse.n4js.analysis.BaseAnalyser;
import org.eclipse.n4js.n4JS.Script;
import org.junit.Assert;

public class NegativeAnalyser
extends BaseAnalyser
implements Analyser {
    public NegativeAnalyser(Logger logger) {
        super(logger);
    }

    public NegativeAnalyser(Logger logger, boolean logCode) {
        super(logger, logCode);
    }

    @Override
    public void analyse(Script script, String codeName, String code) {
        List<Resource.Diagnostic> errors = super.getScriptErrors(script);
        if (errors.isEmpty()) {
            String msg = "expected errors in " + codeName + " but there was not a single one";
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(msg).append("\n");
                sb.append("========== " + codeName + " ==========\n");
                if (this.logCode) {
                    sb.append(code).append("\n");
                }
                sb.append("========================================").append("\n");
                this.logger.debug((Object)sb);
            }
            Assert.assertEquals((String)msg, (Object)code, (Object)codeName);
        }
    }

    @Override
    public boolean isNegative() {
        return true;
    }
}

