/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.csv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.n4js.csv.CSVData;
import org.eclipse.n4js.csv.CSVRecord;
import org.eclipse.n4js.utils.SimpleParser;
import org.eclipse.n4js.utils.SimpleParserException;

public class CSVParser
extends SimpleParser {
    private final Tokenizer tokenizer;

    private CSVParser(String data) {
        this.tokenizer = new Tokenizer(data);
    }

    private CSVParser(String path, Charset encoding) throws IOException {
        this(Paths.get(path, new String[0]), encoding);
    }

    private CSVParser(Path path, Charset encoding) throws IOException {
        this(new String(Files.readAllBytes(path), encoding));
    }

    public static CSVData parse(String data) throws SimpleParserException {
        return new CSVParser(data).doParse();
    }

    public static CSVData parse(String path, Charset encoding) throws IOException, SimpleParserException {
        return new CSVParser(path, encoding).doParse();
    }

    public static CSVData parse(Path path, Charset encoding) throws IOException, SimpleParserException {
        return new CSVParser(path, encoding).doParse();
    }

    private CSVData doParse() throws SimpleParserException {
        CSVData result = new CSVData();
        this.tokenizer.reset();
        SimpleParser.Token token = this.tokenizer.nextToken().expect((Object[])new TokenType[]{TokenType.EOF, TokenType.ROW_SEPARATOR, TokenType.FIELD_SEPARATOR, TokenType.FIELD});
        while (!token.hasType((Object[])new TokenType[]{TokenType.EOF})) {
            this.tokenizer.pushToken(token);
            result.add(this.parseRow());
            token = this.tokenizer.nextToken();
        }
        return result;
    }

    private CSVRecord parseRow() throws SimpleParserException {
        CSVRecord result = new CSVRecord();
        SimpleParser.Token token = null;
        do {
            result.add(this.parseField());
            token = this.tokenizer.nextToken().expect((Object[])new TokenType[]{TokenType.FIELD_SEPARATOR, TokenType.ROW_SEPARATOR, TokenType.EOF});
        } while (!token.hasType((Object[])new TokenType[]{TokenType.ROW_SEPARATOR, TokenType.EOF}));
        return result;
    }

    private String parseField() throws SimpleParserException {
        SimpleParser.Token token = this.tokenizer.nextToken().expect((Object[])new TokenType[]{TokenType.FIELD, TokenType.ROW_SEPARATOR, TokenType.FIELD_SEPARATOR, TokenType.EOF});
        if (token.hasType((Object[])new TokenType[]{TokenType.FIELD})) {
            return token.data;
        }
        this.tokenizer.pushToken(token);
        return "";
    }

    private static enum TokenType {
        FIELD,
        FIELD_SEPARATOR,
        ROW_SEPARATOR,
        EOF;

    }

    private static class Tokenizer
    extends SimpleParser.SimpleTokenizer<TokenType> {
        private static final char COMMA = ',';
        private static final char NEWLINE = '\n';
        private static final char CARRIAGE_RETURN = '\r';
        private static final char DOUBLE_QUOTATION_MARK = '\"';

        Tokenizer(String data) {
            super(data);
        }

        protected SimpleParser.Token<TokenType> readToken() throws SimpleParserException {
            while (!this.eof()) {
                SimpleParser.TokenPosition position = this.getTokenPosition();
                char c = this.getCurrentChar();
                if (c == ',') {
                    this.advance();
                    return this.createTokenFromSubstring((Object)TokenType.FIELD_SEPARATOR, position);
                }
                if (c == '\n') {
                    this.advance();
                    return this.createTokenFromSubstring((Object)TokenType.ROW_SEPARATOR, position);
                }
                if (c != '\r') {
                    return this.readField();
                }
                this.advance();
            }
            return new SimpleParser.Token((Object)TokenType.EOF, this.getTokenPosition());
        }

        private SimpleParser.Token<TokenType> readField() {
            if (this.getCurrentChar() == '\"') {
                return this.readQuotedField();
            }
            SimpleParser.TokenPosition position = this.getTokenPosition();
            char c = this.getCurrentChar();
            while (c != '\r' && c != '\n' && c != ',' && !this.eof()) {
                this.advance();
                if (this.eof()) continue;
                c = this.getCurrentChar();
            }
            SimpleParser.Token result = this.createTokenFromSubstring((Object)TokenType.FIELD, position);
            if (c == '\r') {
                this.advance();
            }
            return result;
        }

        private SimpleParser.Token<TokenType> readQuotedField() {
            this.advance();
            SimpleParser.TokenPosition position = this.getTokenPosition();
            StringBuilder buf = new StringBuilder();
            while (!this.eof()) {
                char c = this.getCurrentCharAndAdvance();
                if (c == '\"') {
                    if (this.eof() || this.getCurrentChar() != '\"') {
                        return new SimpleParser.Token((Object)TokenType.FIELD, position, this.getTokenLength(position) - 2, buf.toString());
                    }
                    this.advance();
                }
                buf.append(c);
            }
            return new SimpleParser.Token((Object)TokenType.EOF, this.getTokenPosition());
        }
    }
}

