/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.projectModel;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.tests.projectModel.AbstractProjectModelSetup;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractProjectModelTest<Loc extends SafeURI<Loc>> {
    @Inject
    private ValidationTestHelper validationTestHelper;
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private LibraryManager libraryManager;
    public final N4JSProjectName myProjectName = new N4JSProjectName("myProject");
    protected Loc myProjectURI;
    public final N4JSProjectName libProjectName = new N4JSProjectName("libProject");
    protected Loc libProjectURI;
    private AbstractProjectModelSetup<Loc> setup;

    protected abstract AbstractProjectModelSetup<Loc> createSetup();

    protected abstract String[] getExpectedIssuesInInitialSetup(N4JSProjectName var1);

    public void setMyProjectURI(Loc myProjectURI) {
        this.myProjectURI = myProjectURI;
    }

    public void setLibProjectURI(Loc libProjectURI) {
        this.libProjectURI = libProjectURI;
    }

    @Before
    public void setUp() {
        this.setup = this.createSetup();
        this.createTempProjects();
        this.libraryManager.registerAllExternalProjects((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull(this.myProjectURI);
        Assert.assertNotNull(this.libProjectURI);
    }

    private void validateTempProjects() throws IOException {
        this.validateProjectDescription((SafeURI<?>)this.myProjectURI, this.getExpectedIssuesInInitialSetup(this.myProjectName));
        this.validateProjectDescription((SafeURI<?>)this.libProjectURI, this.getExpectedIssuesInInitialSetup(this.libProjectName));
    }

    private void validateProjectDescription(SafeURI<?> projectLocation, String ... expectedIssues) throws IOException {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        SafeURI projectDescriptionURI = projectLocation.appendSegment("package.json");
        Resource projectDescriptionResource = resourceSet.createResource(projectDescriptionURI.toURI());
        projectDescriptionResource.load(Collections.emptyMap());
        List issues = this.validationTestHelper.validate(projectDescriptionResource);
        String allIssuesStr = issues.stream().map(issue -> "line " + issue.getLineNumber() + ": " + issue.getMessage()).collect(Collectors.joining("\n"));
        String expectedIssuesStr = Joiner.on((String)"\n").join((Object[])expectedIssues);
        Assert.assertEquals((String)("Unexpected issues in project description file " + projectDescriptionURI.toString() + "."), (Object)expectedIssuesStr, (Object)allIssuesStr);
    }

    private void deleteTempProjects() {
        this.setup.deleteTempProjects();
        this.libraryManager.registerAllExternalProjects((IProgressMonitor)new NullProgressMonitor());
    }

    private void createTempProjects() {
        this.setup.createTempProjects();
    }

    @After
    public void tearDown() {
        this.deleteTempProjects();
        this.setup = null;
        this.myProjectURI = null;
        this.libProjectURI = null;
    }

    @Test
    public void testSetup() throws IOException {
        Assert.assertEquals((Object)this.myProjectName.getRawName(), (Object)this.myProjectURI.getName());
        Assert.assertEquals((Object)this.libProjectName.getRawName(), (Object)this.libProjectURI.getName());
        this.validateTempProjects();
    }
}

