/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.xtext.util.Strings;

public class LibraryChange {
    public final LibraryChangeType type;
    public final FileURI location;
    public final N4JSProjectName name;
    public final String version;

    public LibraryChange(LibraryChangeType type, FileURI location, N4JSProjectName name, String version) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.type = type;
        this.location = location;
        this.name = name;
        this.version = Strings.emptyIfNull((String)version);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LibraryChange)) {
            return false;
        }
        LibraryChange lc = (LibraryChange)o;
        if (this.version != null && lc.version != null && this.version.equals(lc.version)) {
            return true;
        }
        if (this.version == null || lc.version == null) {
            return false;
        }
        return this.location.equals(lc.location);
    }

    public int hashCode() {
        if (this.version != null) {
            return Objects.hashCode((Object[])new Object[]{this.location, this.version});
        }
        return this.location.hashCode();
    }

    public String toString() {
        String versionString = this.version.isEmpty() ? "" : "@" + this.version;
        return String.valueOf(this.type.name()) + ":" + this.name + versionString;
    }

    public static enum LibraryChangeType {
        Install,
        Uninstall,
        Added,
        Removed,
        Updated;

    }
}

