/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.tests.issues.IssuePropertyMatcherBase;
import org.eclipse.xtext.validation.Issue;

public class URIPropertyMatcher
extends IssuePropertyMatcherBase {
    private final Mode mode;
    private final URI expectedPattern;
    private final Function<Issue, URI> getActualValue;

    protected URIPropertyMatcher(String propertyName, Mode mode, URI expectedPattern, Function<Issue, URI> getActualValue) {
        super(propertyName);
        this.mode = mode;
        this.expectedPattern = Objects.requireNonNull(expectedPattern);
        this.getActualValue = Objects.requireNonNull(getActualValue);
    }

    @Override
    public boolean matches(Issue issue) {
        URI actualValue = this.getActualValue.apply(issue);
        if (actualValue == null) {
            return false;
        }
        List actualSegments = actualValue.segmentsList();
        List expectedSegments = this.expectedPattern.segmentsList();
        switch (this.mode) {
            case StartsWith: {
                return Collections.indexOfSubList(actualSegments, expectedSegments) == 0;
            }
            case EndsWith: {
                return Collections.lastIndexOfSubList(actualSegments, expectedSegments) == actualSegments.size() - expectedSegments.size();
            }
            case Equals: {
                return actualSegments.equals(expectedSegments);
            }
        }
        throw new IllegalStateException("Unknown URI property matching mode: " + (Object)((Object)this.mode));
    }

    @Override
    protected String explainMismatch(Issue issue) {
        URI actualValue = this.getActualValue.apply(issue);
        if (actualValue == null) {
            return "Actual value is null";
        }
        switch (this.mode) {
            case StartsWith: {
                return "'" + this.expectedPattern + "' is not a prefix of value '" + actualValue + "'";
            }
            case EndsWith: {
                return "'" + this.expectedPattern + "' is not a suffix of value '" + actualValue + "'";
            }
            case Equals: {
                return "Value '" + actualValue + "' is not equal to expected value'" + this.expectedPattern + "'";
            }
        }
        throw new IllegalStateException("Unknown URI property matching mode: " + (Object)((Object)this.mode));
    }

    @Override
    public String getDescription() {
        switch (this.mode) {
            case StartsWith: {
                return "'" + this.expectedPattern + "' is a prefix of property '" + this.getPropertyName() + "'";
            }
            case EndsWith: {
                return "'" + this.expectedPattern + "' is a suffix of property '" + this.getPropertyName() + "'";
            }
            case Equals: {
                return "Property '" + this.getPropertyName() + "' is equal to expected value'" + this.expectedPattern + "'";
            }
        }
        throw new IllegalStateException("Unknown URI property matching mode: " + (Object)((Object)this.mode));
    }

    public static enum Mode {
        StartsWith,
        EndsWith,
        Equals;

    }
}

