/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.MultiplicativeOperator;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.BootstrapCallAssistant;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InterfaceDeclarationTransformation
extends Transformation {
    @Inject
    private BootstrapCallAssistant bootstrapCallAssistant;
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
        this.typeAssistant.assertClassifierPreConditions();
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4InterfaceDeclaration> _function = it -> this.transformInterfaceDecl((N4InterfaceDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4InterfaceDeclaration.class, false).forEach(_function);
    }

    private void transformInterfaceDecl(N4InterfaceDeclaration ifcDecl) {
        SymbolTableEntry ifcSTE = this.findSymbolTableEntryForElement((NamedElement)ifcDecl, true);
        VariableDeclaration varDecl = this.createVarDecl(ifcDecl);
        Statement[] fieldDefaults = this.createInstanceFieldDefaultsObject(ifcDecl, ifcSTE);
        List<Statement> staticFieldInits = this.createStaticFieldInitializations(ifcSTE, ifcDecl);
        Statement[] memberDefs = this.bootstrapCallAssistant.createInterfaceMemberDefinitionSection(ifcDecl);
        ExpressionStatement makeIfcCall = this.bootstrapCallAssistant.createMakeInterfaceCall(ifcDecl);
        this.getState().tracer.copyTrace((EObject)ifcDecl, (EObject[])fieldDefaults);
        this.getState().tracer.copyTrace((EObject)ifcDecl, (EObject[])Conversions.unwrapArray(staticFieldInits, EObject.class));
        this.getState().tracer.copyTrace((EObject)ifcDecl, (EObject[])memberDefs);
        this.getState().tracer.copyTrace((EObject)ifcDecl, new EObject[]{makeIfcCall});
        this.replace(ifcDecl, varDecl);
        EObject root = TranspilerUtils.orContainingExportDeclaration((EObject)varDecl.eContainer());
        Iterable _plus = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)fieldDefaults)), staticFieldInits);
        Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)((Iterable)Conversions.doWrapArray((Object)memberDefs)));
        Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ExpressionStatement[]{makeIfcCall})));
        this.insertAfter(root, (EObject[])Conversions.unwrapArray((Object)_plus_2, EObject.class));
        this.getState().info.markAsToHoist(varDecl);
    }

    private VariableDeclaration createVarDecl(N4InterfaceDeclaration ifcDecl) {
        VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration((String)ifcDecl.getName());
        Procedures.Procedure1 _function = it -> it.setExpression((Expression)TranspilerBuilderBlocks._ObjLit());
        return (VariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)__VariableDeclaration, (Procedures.Procedure1)_function);
    }

    private Statement[] createInstanceFieldDefaultsObject(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        SymbolTableEntryInternal $fieldDefaultsSTE = this.steFor_$fieldDefaults();
        Functions.Function1 _function = it -> {
            boolean _isStatic = it.isStatic();
            return !_isStatic;
        };
        List fields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ifcDecl.getOwnedFields(), (Functions.Function1)_function));
        boolean _isEmpty = fields.isEmpty();
        if (_isEmpty) {
            return new Statement[0];
        }
        Functions.Function1 _function_1 = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName());
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_2 = field -> {
            String _name = field.getName();
            IdentifierRef_IM _xifexpression = null;
            boolean _hasNonTrivialInitExpression = this.hasNonTrivialInitExpression((N4FieldDeclaration)field);
            if (_hasNonTrivialInitExpression) {
                Object _xifexpression_1 = null;
                boolean _canSkipFunctionWrapping = this.canSkipFunctionWrapping(field.getExpression());
                _xifexpression_1 = _canSkipFunctionWrapping ? field.getExpression() : TranspilerBuilderBlocks._ArrowFunc((boolean)false, (FormalParameter[])new FormalParameter[0], (Expression)this.wrapInParenthesesIfNeeded(field.getExpression()));
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = this.undefinedRef();
            }
            return Pair.of((Object)_name, (Object)_xifexpression);
        };
        ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)ifcSTE, (SymbolTableEntry[])new SymbolTableEntry[]{$fieldDefaultsSTE}), (Expression)TranspilerBuilderBlocks._ObjLit((Pair[])((Pair[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)fields, (Functions.Function1)_function_1), (Functions.Function1)_function_2), Pair.class)))));
        return new Statement[]{__ExprStmnt};
    }

    private Expression wrapInParenthesesIfNeeded(Expression expr) {
        if (expr instanceof CommaExpression || expr instanceof ObjectLiteral || expr instanceof AwaitExpression || expr instanceof YieldExpression || expr instanceof PromisifyExpression) {
            return TranspilerBuilderBlocks._Parenthesis((Expression)expr);
        }
        return expr;
    }

    private boolean canSkipFunctionWrapping(Expression initExpression) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (initExpression instanceof BooleanLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof NullLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof NumericLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof StringLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && initExpression instanceof UnaryExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            UnaryOperator _op = ((UnaryExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case INC: {
                        _switchResult_1 = false;
                        break;
                    }
                    case DEC: {
                        _switchResult_1 = false;
                        break;
                    }
                    case DELETE: {
                        _switchResult_1 = false;
                        break;
                    }
                    case POS: {
                        _switchResult_1 = true;
                        break;
                    }
                    case NEG: {
                        _switchResult_1 = true;
                        break;
                    }
                    case INV: {
                        _switchResult_1 = true;
                        break;
                    }
                    case NOT: {
                        _switchResult_1 = true;
                        break;
                    }
                    case TYPEOF: {
                        _switchResult_1 = true;
                        break;
                    }
                    case VOID: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((UnaryExpression)initExpression).getExpression());
        }
        if (!_matched && initExpression instanceof AdditiveExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            AdditiveOperator _op = ((AdditiveExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case ADD: {
                        _switchResult_1 = true;
                        break;
                    }
                    case SUB: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((AdditiveExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((AdditiveExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof MultiplicativeExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            MultiplicativeOperator _op = ((MultiplicativeExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case TIMES: {
                        _switchResult_1 = true;
                        break;
                    }
                    case DIV: {
                        _switchResult_1 = true;
                        break;
                    }
                    case MOD: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((MultiplicativeExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((MultiplicativeExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof BinaryBitwiseExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            BinaryBitwiseOperator _op = ((BinaryBitwiseExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case OR: {
                        _switchResult_1 = true;
                        break;
                    }
                    case XOR: {
                        _switchResult_1 = true;
                        break;
                    }
                    case AND: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((BinaryBitwiseExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((BinaryBitwiseExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof BinaryLogicalExpression) {
            boolean isFreeOfSideEffect;
            _matched = true;
            boolean _switchResult_1 = false;
            BinaryLogicalOperator _op = ((BinaryLogicalExpression)initExpression).getOp();
            if (_op != null) {
                switch (_op) {
                    case OR: {
                        _switchResult_1 = true;
                        break;
                    }
                    case AND: {
                        _switchResult_1 = true;
                        break;
                    }
                }
            }
            return (isFreeOfSideEffect = _switchResult_1) && this.canSkipFunctionWrapping(((BinaryLogicalExpression)initExpression).getLhs()) && this.canSkipFunctionWrapping(((BinaryLogicalExpression)initExpression).getRhs());
        }
        if (!_matched && initExpression instanceof CastExpression) {
            _matched = true;
            _switchResult = this.canSkipFunctionWrapping(((CastExpression)initExpression).getExpression());
        }
        if (!_matched && initExpression instanceof ParenExpression) {
            _matched = true;
            _switchResult = this.canSkipFunctionWrapping(((ParenExpression)initExpression).getExpression());
        }
        if (!_matched && initExpression instanceof IdentifierRef) {
            TField _fieldUndefined;
            _matched = true;
            IdentifiableElement _id = ((IdentifierRef)initExpression).getId();
            return _id == (_fieldUndefined = RuleEnvironmentExtensions.getGlobalObjectScope((RuleEnvironment)this.getState().G).getFieldUndefined());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected List<Statement> createStaticFieldInitializations(SymbolTableEntry ifcSTE, N4InterfaceDeclaration ifcDecl) {
        Functions.Function1 _function = it -> it.isStatic();
        Functions.Function1 _function_1 = it -> {
            Expression _expression = it.getExpression();
            return _expression != null;
        };
        Functions.Function1 _function_2 = fieldDecl -> {
            AssignmentExpression __AssignmentExpr = TranspilerBuilderBlocks._AssignmentExpr();
            Procedures.Procedure1 _function_3 = it -> {
                it.setLhs((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)ifcSTE, (SymbolTableEntry[])new SymbolTableEntry[]{this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true)}));
                it.setRhs(fieldDecl.getExpression());
            };
            AssignmentExpression _doubleArrow = (AssignmentExpression)ObjectExtensions.operator_doubleArrow((Object)__AssignmentExpr, (Procedures.Procedure1)_function_3);
            return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ifcDecl.getOwnedMembers(), N4FieldDeclaration.class), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }
}

