/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.runner.XpectTestFiles;
import org.eclipse.xtext.util.UriExtensions;

public class SafeURIFileCollector
extends XpectTestFiles.XpectTestFileCollector {
    private final UriExtensions uriExtensions = new UriExtensions();

    public SafeURIFileCollector(Class<?> owner, XpectTestFiles ctx) {
        super(owner, ctx);
    }

    protected URI createURI(File file) {
        throw new UnsupportedOperationException("Never called by super impl");
    }

    public URI deresolveToProject(URI uri) {
        return uri.deresolve(this.uriExtensions.withEmptyAuthority(this.getBundle().getRootURI()));
    }

    public Collection<URI> getAllURIs() {
        ArrayList result = Lists.newArrayList((Iterable)super.getAllURIs());
        int i = 0;
        while (i < result.size()) {
            try {
                URI uri = this.uriExtensions.withEmptyAuthority((URI)result.get(i));
                result.set(i, uri);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong URI (" + result.get(i) + "). Check given directory and/or files");
            }
            ++i;
        }
        return result;
    }

    protected URI resolvePlatformResourceURI(URI uri) {
        URI result = super.resolvePlatformResourceURI(uri);
        return this.uriExtensions.withEmptyAuthority(result);
    }

    protected URI resolveProjectRelativeURI(URI uri) {
        URI result = super.resolveProjectRelativeURI(uri);
        return this.uriExtensions.withEmptyAuthority(result);
    }

    public URI resolveURI(URI base, String newURI) {
        URI uri = super.resolveURI(base, newURI);
        return this.uriExtensions.withEmptyAuthority(uri);
    }
}

