/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import org.eclipse.n4js.conversion.AbstractN4JSStringValueConverter;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public abstract class AbstractTemplateSegmentValueConverter
extends AbstractN4JSStringValueConverter {
    protected void assertValidValue(String value) {
        super.assertValidValue((Object)value);
        int i = 1;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '`') {
                throw this.invalidRawTemplateString(value);
            }
            if (c == '$' && i + 1 < value.length() && value.charAt(i + 1) == '{') {
                throw this.invalidRawTemplateString(value);
            }
            ++i;
        }
    }

    private ValueConverterException invalidRawTemplateString(String value) {
        return new ValueConverterException("Cannot express the value '" + value + "' as a raw template string.", null, null);
    }

    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            int len = string.length();
            int leftLen = this.getLeftDelimiter().length();
            if (len == leftLen) {
                throw this.newN4JSValueConverterException(node, "");
            }
            int lastIdx = len - this.getRightDelimiter().length();
            if (string.startsWith(this.getLeftDelimiter()) && string.endsWith(this.getRightDelimiter())) {
                int minLen = leftLen + this.getRightDelimiter().length();
                if (len > minLen && string.charAt(lastIdx - 1) == '\\' && (len == minLen + 1 || string.charAt(lastIdx - 2) != '\\')) {
                    String value = AbstractTemplateSegmentValueConverter.convertFromN4JSString(string.substring(leftLen), node, false);
                    throw this.newN4JSValueConverterException(node, value);
                }
                return AbstractTemplateSegmentValueConverter.convertFromN4JSString(string.substring(leftLen, lastIdx), node, true);
            }
            String value = AbstractTemplateSegmentValueConverter.convertFromN4JSString(string.substring(leftLen), node, false);
            throw this.newN4JSValueConverterException(node, value);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    protected abstract N4JSValueConverterWithValueException newN4JSValueConverterException(INode var1, String var2);
}

