/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.IAcceptor;

public final class UserdataMapper {
    private static final Logger LOGGER = Logger.getLogger(UserdataMapper.class);
    public static final String USERDATA_KEY_SERIALIZED_SCRIPT = "serializedScript";
    public static final String USERDATA_KEY_DEPENDENCIES = "dependencies";
    public static final String USERDATA_KEY_STATIC_POLYFILL_CONTENTHASH = "staticPolyfillContentHash";
    public static final String USERDATA_KEY_TIMESTAMP = "timestamp";
    public static final String USERDATA_KEY_AST_MD5 = "astMD5";
    private static final Boolean BINARY = Boolean.TRUE;
    private static final String TRANSFORMATION_CHARSET_NAME = Charsets.UTF_8.name();
    private static Joiner joiner = Joiner.on((String)",");
    private static final Splitter splitter = Splitter.on((char)',').omitEmptyStrings();

    public static Map<String, String> createUserData(TModule exportedModule) throws IOException, UnsupportedEncodingException {
        if (exportedModule.isPreLinkingPhase()) {
            throw new AssertionError((Object)"Module may not be from the preLinkingPhase");
        }
        Resource originalResourceUncasted = exportedModule.eResource();
        if (!(originalResourceUncasted instanceof N4JSResource)) {
            throw new IllegalArgumentException("module must be contained in an N4JSResource");
        }
        N4JSResource originalResource = (N4JSResource)originalResourceUncasted;
        originalResource.performPostProcessing();
        if (EcoreUtilN4.hasUnresolvedProxies((EObject)exportedModule) || TypeUtils.containsDeferredTypeRefs((EObject)exportedModule)) {
            return UserdataMapper.createTimestampUserData(exportedModule);
        }
        URI resourceURI = originalResource.getURI();
        XMIResourceImpl resourceForUserData = new XMIResourceImpl(resourceURI);
        resourceForUserData.getContents().add((Object)TypeUtils.copyWithProxies((EObject)exportedModule));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resourceForUserData.save((OutputStream)baos, UserdataMapper.getOptions(resourceURI, BINARY));
        String serializedScript = BINARY != false ? Base64.getEncoder().encodeToString(baos.toByteArray()) : baos.toString(TRANSFORMATION_CHARSET_NAME);
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(USERDATA_KEY_SERIALIZED_SCRIPT, serializedScript);
        String astMD5 = exportedModule.getAstMD5();
        if (astMD5 != null) {
            ret.put(USERDATA_KEY_AST_MD5, astMD5);
        }
        ret.put("MAIN_MODULE", Boolean.toString(exportedModule.isMainModule()));
        if (exportedModule.isStaticPolyfillModule()) {
            String contentHash = Integer.toHexString(originalResource.getParseResult().getRootNode().hashCode());
            ret.put(USERDATA_KEY_STATIC_POLYFILL_CONTENTHASH, contentHash);
        }
        return ret;
    }

    public static Map<String, String> createTimestampUserData(TModule module) {
        Resource resource = module.eResource();
        long timestamp = 0L;
        timestamp = resource instanceof N4JSResource ? ((N4JSResource)resource).getModificationStamp() : System.currentTimeMillis();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(USERDATA_KEY_TIMESTAMP, String.valueOf(timestamp));
        return result;
    }

    private static Map<Object, Object> getOptions(URI resourceURI, Boolean binary) {
        return ImmutableMap.of((Object)"BINARY", (Object)binary, (Object)"URI_HANDLER", (Object)((Object)new LocalResourceAwareURIHandler(resourceURI)));
    }

    public static String getDeserializedModuleFromDescriptionAsString(IEObjectDescription eObjectDescription, URI uri) throws IOException {
        TModule module = UserdataMapper.getDeserializedModuleFromDescription(eObjectDescription, uri);
        if (module == null) {
            return null;
        }
        XMIResourceImpl resourceForUserData = new XMIResourceImpl(uri);
        resourceForUserData.getContents().add((Object)module);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resourceForUserData.save((OutputStream)baos, UserdataMapper.getOptions(uri, false));
        return baos.toString(TRANSFORMATION_CHARSET_NAME);
    }

    public static TModule getDeserializedModuleFromDescription(IEObjectDescription eObjectDescription, URI uri) {
        String serializedData = eObjectDescription.getUserData(USERDATA_KEY_SERIALIZED_SCRIPT);
        if (Strings.isNullOrEmpty((String)serializedData)) {
            return null;
        }
        XMIResourceImpl xres = new XMIResourceImpl(uri);
        try {
            boolean binary = !serializedData.startsWith("<");
            ByteArrayInputStream bais = new ByteArrayInputStream(binary ? Base64.getDecoder().decode(serializedData) : serializedData.getBytes(TRANSFORMATION_CHARSET_NAME));
            xres.load((InputStream)bais, UserdataMapper.getOptions(uri, binary));
        }
        catch (Exception e) {
            LOGGER.warn((Object)("error deserializing module from IEObjectDescription: " + uri));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("error deserializing module from IEObjectDescription=" + eObjectDescription + ": " + uri), (Throwable)e);
            }
            return null;
        }
        EList contents = xres.getContents();
        if (contents.isEmpty() || !(contents.get(0) instanceof TModule)) {
            return null;
        }
        TModule module = (TModule)contents.get(0);
        xres.getContents().clear();
        String astMD5 = eObjectDescription.getUserData(USERDATA_KEY_AST_MD5);
        module.setAstMD5(astMD5);
        return module;
    }

    public static boolean hasSerializedModule(IEObjectDescription eObjectDescription) {
        return eObjectDescription.getUserData(USERDATA_KEY_SERIALIZED_SCRIPT) != null;
    }

    public static void writeDependenciesToUserData(N4JSResource resource, Map<String, String> userData) {
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        UserdataMapper.computeCrossRefs(resource, (IAcceptor<TModule>)((IAcceptor)targetObj -> {
            Resource targetRes = targetObj.eResource();
            if (targetRes != null) {
                dependencies.add(targetRes.getURI());
            }
        }));
        userData.put(USERDATA_KEY_DEPENDENCIES, joiner.join((Iterable)dependencies));
    }

    private static void computeCrossRefs(N4JSResource resource, IAcceptor<TModule> acceptor) {
        Script script = resource.getScript();
        if (script != null && !script.eIsProxy()) {
            for (ScriptElement elem : script.getScriptElements()) {
                TModule module;
                if (!(elem instanceof ImportDeclaration) || (module = ((ImportDeclaration)elem).getModule()) == null || module.eIsProxy()) continue;
                acceptor.accept((Object)module);
            }
        }
    }

    public static Optional<List<String>> readDependenciesFromDescription(IResourceDescription description) {
        Iterable modules = description.getExportedObjectsByType(TypesPackage.Literals.TMODULE);
        for (IEObjectDescription module : modules) {
            String dependenciesStr = module.getUserData(USERDATA_KEY_DEPENDENCIES);
            if (dependenciesStr == null) continue;
            return Optional.of(splitter.splitToList((CharSequence)dependenciesStr));
        }
        return Optional.empty();
    }

    private static class LocalResourceAwareURIHandler
    extends URIHandlerImpl {
        private final URI resourceURI;

        LocalResourceAwareURIHandler(URI resourceURI) {
            this.resourceURI = resourceURI;
        }

        public URI deresolve(URI uri) {
            if (uri.trimFragment().equals(this.resourceURI)) {
                return super.deresolve(URI.createURI((String)("#" + uri.fragment())));
            }
            return super.deresolve(uri);
        }

        public URI resolve(URI uri) {
            if (uri.trimFragment().toString().isEmpty()) {
                return this.resourceURI.appendFragment(uri.fragment());
            }
            return super.resolve(uri);
        }
    }
}

