/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.GraphProvider;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.graphics.GC;

public abstract class Graph<P extends GraphProvider<?, ?>> {
    protected final List<Node> nodes = new ArrayList<Node>();
    protected final List<Edge> edges = new ArrayList<Edge>();

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
    }

    public Node getNodeAt(float x, float y) {
        for (Node n : this.nodes) {
            if (!n.contains(x, y)) continue;
            return n;
        }
        return null;
    }

    public Rectangle getBounds() {
        return GraphUtils.getBounds(this.nodes.stream());
    }

    void setGraph(List<Node> nodes, List<Edge> edges) {
        this.clear();
        this.nodes.addAll(nodes);
        this.edges.addAll(edges);
    }

    public abstract void build(P var1, Object var2);

    public abstract void layout(GC var1);
}

