/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.projects;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.util.UriExtensions;

@Singleton
public class AutoDiscoveryFileBasedWorkspace
extends FileBasedWorkspace {
    @Inject
    public AutoDiscoveryFileBasedWorkspace(ProjectDescriptionLoader projectDescriptionLoader, UriExtensions uriExtensions) {
        super(projectDescriptionLoader, uriExtensions);
    }

    public FileURI fromURI(URI unsafe) {
        if ((!unsafe.isFile() || unsafe.isRelative()) && (unsafe = URIUtils.normalize((URI)unsafe)).isRelative()) {
            return null;
        }
        return super.fromURI(unsafe);
    }

    public FileURI findProjectWith(FileURI nestedLocation) {
        FileURI closestProjectLocation = AutoDiscoveryFileBasedWorkspace.findClosestProjectLocation(nestedLocation);
        FileURI knownProjectLocation = super.findProjectWith(nestedLocation);
        if (!(closestProjectLocation == null || knownProjectLocation != null && knownProjectLocation.equals((Object)closestProjectLocation))) {
            this.registerProject(closestProjectLocation);
        }
        return closestProjectLocation;
    }

    private static FileURI findClosestProjectLocation(FileURI location) {
        return (FileURI)location.getProjectRoot();
    }
}

