/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.fileextensions;

import com.google.common.base.Splitter;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.n4js.fileextensions.FileExtensionType;

@Singleton
public class FileExtensionsRegistry {
    private static final Logger LOGGER = Logger.getLogger(FileExtensionsRegistry.class);
    private static final String FILE_EXTENSIONS_POINT_ID = "org.eclipse.n4js.utils.fileExtensions";
    private static final String ATT_TRANSPILABLE_FILE_EXTENSIONS = "transpilableFileExtensions";
    private static final String ATT_TEST_FILE_EXTENSIONS = "testFileExtensions";
    private static final String ATT_RUNNABLE_FILE_EXTENSIONS = "runnableFileExtensions";
    private static final String ATT_TYPABLE_FILE_EXTENSIONS = "typableFileExtensions";
    private static final String ATT_RAW_FILE_EXTENSIONS = "rawFileExtensions";
    private static final String ATT_FILE_EXTENSION = "extensions";
    private boolean isInitialized = false;
    private final Collection<String> transpilableFileExtensions = new ArrayList<String>();
    private final Collection<String> testFileExtensions = new ArrayList<String>();
    private final Collection<String> runnableFileExtensions = new ArrayList<String>();
    private final Collection<String> typableFileExtensions = new ArrayList<String>();
    private final Collection<String> rawFileExtensions = new ArrayList<String>();

    public void register(String fileExtension, FileExtensionType extensionType) {
        switch (extensionType) {
            case TRANSPILABLE_FILE_EXTENSION: {
                this.transpilableFileExtensions.add(fileExtension);
                break;
            }
            case TESTABLE_FILE_EXTENSION: {
                this.testFileExtensions.add(fileExtension);
                break;
            }
            case RUNNABLE_FILE_EXTENSION: {
                this.runnableFileExtensions.add(fileExtension);
                break;
            }
            case TYPABLE_FILE_EXTENSION: {
                this.typableFileExtensions.add(fileExtension);
                break;
            }
            case RAW_FILE_EXTENSION: {
                this.rawFileExtensions.add(fileExtension);
                break;
            }
            default: {
                throw new UnsupportedOperationException("This file extension type " + (Object)((Object)extensionType) + " is not supported yet");
            }
        }
    }

    public Collection<String> getFileExtensions(FileExtensionType extensionType) {
        if (!this.isInitialized) {
            this.initialize();
        }
        switch (extensionType) {
            case TRANSPILABLE_FILE_EXTENSION: {
                return Collections.unmodifiableCollection(this.transpilableFileExtensions);
            }
            case TESTABLE_FILE_EXTENSION: {
                return Collections.unmodifiableCollection(this.testFileExtensions);
            }
            case RUNNABLE_FILE_EXTENSION: {
                return Collections.unmodifiableCollection(this.runnableFileExtensions);
            }
            case TYPABLE_FILE_EXTENSION: {
                return Collections.unmodifiableCollection(this.typableFileExtensions);
            }
            case RAW_FILE_EXTENSION: {
                return Collections.unmodifiableCollection(this.rawFileExtensions);
            }
        }
        throw new UnsupportedOperationException("This file extension type " + (Object)((Object)extensionType) + " is not supported yet");
    }

    private void initialize() {
        if (this.isInitialized) {
            throw new IllegalStateException("may invoke method initialize() only once");
        }
        this.isInitialized = true;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = registry.getExtensionPoint(FILE_EXTENSIONS_POINT_ID).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElems;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElems = extension.getConfigurationElements();
                int n3 = configElems.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement elem = iConfigurationElementArray[n4];
                    try {
                        List fileExtensions = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)elem.getAttribute(ATT_FILE_EXTENSION));
                        String elementName = elem.getName();
                        if (ATT_TRANSPILABLE_FILE_EXTENSIONS.equals(elementName)) {
                            this.transpilableFileExtensions.addAll(fileExtensions);
                        } else if (ATT_TEST_FILE_EXTENSIONS.equals(elementName)) {
                            this.testFileExtensions.addAll(fileExtensions);
                        } else if (ATT_RUNNABLE_FILE_EXTENSIONS.equals(elementName)) {
                            this.runnableFileExtensions.addAll(fileExtensions);
                        } else if (ATT_TYPABLE_FILE_EXTENSIONS.equals(elementName)) {
                            this.typableFileExtensions.addAll(fileExtensions);
                        } else if (ATT_RAW_FILE_EXTENSIONS.equals(elementName)) {
                            this.rawFileExtensions.addAll(fileExtensions);
                        } else {
                            LOGGER.error((Object)new UnsupportedOperationException("This file extension type " + elementName + " is not supported yet"));
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"Error while reading extensions for extension point org.eclipse.n4js.utils.fileExtensions", (Throwable)ex);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void reset() {
        this.isInitialized = false;
        this.transpilableFileExtensions.clear();
        this.testFileExtensions.clear();
        this.runnableFileExtensions.clear();
    }
}

