/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectTestFilesCollector;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.XpectRunner;
import org.junit.runner.Description;

public class XpectFileContentsUtil {
    public static Optional<XpectFileContentAccess> getXpectFileContentAccess(Description description) {
        String contents = "";
        boolean containsFixme = false;
        IXpectURIProvider xpectUriProvider = XpectRunner.INSTANCE.getUriProvider();
        if (xpectUriProvider instanceof N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider) {
            N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider n4XpectUriProvider = (N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider)xpectUriProvider;
            String rawFileLocation = n4XpectUriProvider.findRawLocation(description);
            try {
                contents = new String(Files.readAllBytes(Paths.get(rawFileLocation, new String[0])));
            }
            catch (IOException e) {
                N4IDEXpectUIPlugin.logError("cannot read contents of test file", e);
                e.printStackTrace();
                return Optional.empty();
            }
        }
        containsFixme = contents.split("XPECT\\sFIXME").length > 1;
        XpectFileContentAccess xpectFileContetnsAccess = new XpectFileContentAccess(contents, containsFixme);
        return Optional.of(xpectFileContetnsAccess);
    }

    public static class XpectFileContentAccess {
        private final String contents;
        private final boolean containsFixme;

        private XpectFileContentAccess(String contents, boolean containsFixme) {
            this.contents = contents;
            this.containsFixme = containsFixme;
        }

        public String getContetns() {
            return this.contents;
        }

        public boolean containsFixme() {
            return this.containsFixme;
        }
    }
}

