/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.common;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.OffsetRegion;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

@XpectSetupFactory
@XpectImport(value={EObjectCoveringRegionProvider.class})
public class N4JSOffsetAdapter {

    public static class EObjectCoveringRegion
    implements IEObjectCoveringRegion {
        final EObject eObj;
        int offset;

        public EObjectCoveringRegion(EObject eObj, int offset) {
            this.eObj = eObj;
            this.offset = offset;
        }

        public EObject getEObject() {
            return this.eObj;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }

    @XpectSetupFactory
    public static class EObjectCoveringRegionProvider {
        private final IRegion region;
        private final int matchedOffset;
        @ThisResource
        private final XtextResource resource;
        private final XpectInvocation invocation;

        public EObjectCoveringRegionProvider(@ThisResource XtextResource resource, XpectInvocation invocation, OffsetRegion delegate) {
            this.resource = resource;
            this.region = delegate.getMatchedRegion();
            this.invocation = invocation;
            this.matchedOffset = delegate.getMatchedOffset();
        }

        public EObjectCoveringRegionProvider(@ThisResource XtextResource resource, XpectInvocation invocation) {
            this.resource = resource;
            this.region = invocation.getExtendedRegion();
            this.invocation = invocation;
            this.matchedOffset = this.region.getOffset();
        }

        @Creates
        public IEObjectCoveringRegion IEObjectCoveringRegion() {
            boolean haveRegion = this.region != null;
            int offset = haveRegion ? this.region.getOffset() : this.matchedOffset;
            int length = haveRegion ? this.region.getLength() : 0;
            int endOffset = offset + length;
            EObject semanticObject = null;
            ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)this.resource.getParseResult().getRootNode(), (int)offset);
            while (node != null) {
                EObject actualObject = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                if (actualObject != null) {
                    if (haveRegion) {
                        int nodeEndOffset = node.getEndOffset();
                        if (nodeEndOffset <= endOffset || semanticObject == null) {
                            semanticObject = actualObject;
                        }
                        if (nodeEndOffset >= endOffset) {
                            break;
                        }
                    } else if (semanticObject == null) {
                        semanticObject = actualObject;
                        break;
                    }
                }
                node = node.getParent();
            }
            return new EObjectCoveringRegion(semanticObject, offset);
        }
    }

    public static interface IEObjectCoveringRegion
    extends XtextOffsetAdapter.IEObjectOwner {
        public int getOffset();
    }
}

