/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.common;

import org.eclipse.n4js.xpect.common.SafeURIFileCollector;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.runner.XpectTestFiles;
import org.eclipse.xtext.util.Strings;
import org.junit.runners.model.InitializationError;

public class N4JSXpectRunner
extends XpectRunner {
    public N4JSXpectRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected IXpectURIProvider findUriProvider(Class<?> clazz) throws InitializationError {
        String[] files;
        XpectTestFiles.Builder builder = new XpectTestFiles.Builder().relativeTo(XpectTestFiles.FileRoot.PROJECT);
        XpectTestFiles annotation = clazz.getAnnotation(XpectTestFiles.class);
        String baseDir = this.getBaseDir(annotation);
        if (!Strings.isEmpty((String)baseDir)) {
            builder.withBaseDir(baseDir);
        }
        if ((files = this.getFiles(annotation)) != null && files.length > 0) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String removedBaseDir;
                String file = stringArray[n2];
                String trimmed = file.trim();
                String string = removedBaseDir = trimmed.startsWith(baseDir) ? trimmed.substring(baseDir.length() + 1) : trimmed;
                if (!"".equals(removedBaseDir)) {
                    builder.addFile(removedBaseDir);
                }
                ++n2;
            }
        }
        SafeURIFileCollector provider = new SafeURIFileCollector(clazz, (XpectTestFiles)builder);
        return provider;
    }

    private String getBaseDir(XpectTestFiles annotation) {
        String baseDir = System.getProperty("xpectBaseDir");
        if (!Strings.isEmpty((String)baseDir)) {
            return baseDir;
        }
        String string = baseDir = annotation == null ? "" : annotation.baseDir();
        if (!Strings.isEmpty((String)baseDir)) {
            return baseDir;
        }
        return null;
    }

    private String[] getFiles(XpectTestFiles annotation) {
        String[] files;
        String filesString = System.getProperty("xpectFiles");
        if (!Strings.isEmpty((String)filesString)) {
            return filesString.split(";");
        }
        String[] stringArray = files = annotation == null ? new String[]{} : annotation.files();
        if (files != null && files.length > 0) {
            return files;
        }
        return null;
    }
}

