/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.base.Strings;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.n4js.ide.validation.N4JSIssue;
import org.eclipse.n4js.ide.xtext.server.DocumentResourceProvider;
import org.eclipse.n4js.ide.xtext.server.XDocument;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class DiagnosticIssueConverter {
    public Diagnostic toDiagnostic(Issue issue, DocumentResourceProvider documentProvider) {
        Diagnostic result = new Diagnostic();
        result.setCode(issue.getCode());
        result.setMessage(Strings.nullToEmpty((String)issue.getMessage()));
        result.setSeverity(this.toSeverity(issue.getSeverity()));
        Position start = new Position(this.toZeroBasedInt(issue.getLineNumber()), this.toZeroBasedInt(issue.getColumn()));
        Position end = null;
        if (issue instanceof N4JSIssue) {
            N4JSIssue n4jsIssue = (N4JSIssue)issue;
            end = new Position(n4jsIssue.getLineNumberEnd() - 1, n4jsIssue.getColumnEnd() - 1);
        } else {
            URI uri = issue.getUriToProblem();
            XDocument doc = null;
            if (uri != null && documentProvider != null) {
                doc = documentProvider.getDocument(uri);
            }
            if (doc != null) {
                end = doc.getPosition(issue.getOffset() + issue.getLength());
            }
            if (end == null) {
                end = new Position(start.getLine(), start.getCharacter() + 1);
            }
        }
        result.setRange(new Range(start, end));
        return result;
    }

    private int toZeroBasedInt(Integer oneBasedInteger) {
        return oneBasedInteger == null ? 0 : oneBasedInteger - 1;
    }

    protected DiagnosticSeverity toSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return DiagnosticSeverity.Error;
            }
            case IGNORE: {
                return DiagnosticSeverity.Hint;
            }
            case INFO: {
                return DiagnosticSeverity.Information;
            }
            case WARNING: {
                return DiagnosticSeverity.Warning;
            }
        }
        return DiagnosticSeverity.Hint;
    }

    protected Severity toSeverity(DiagnosticSeverity severity) {
        switch (severity) {
            case Error: {
                return Severity.ERROR;
            }
            case Hint: {
                return Severity.IGNORE;
            }
            case Information: {
                return Severity.INFO;
            }
            case Warning: {
                return Severity.WARNING;
            }
        }
        return Severity.IGNORE;
    }

    public Issue toIssue(URI uri, Diagnostic diagnostic, DocumentResourceProvider documentProvider) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setSeverity(this.toSeverity(diagnostic.getSeverity()));
        Range range = diagnostic.getRange();
        Position sPos = range.getStart();
        Position ePos = range.getEnd();
        int offSetStart = 0;
        int offSetEnd = 0;
        if (documentProvider != null) {
            XDocument document = documentProvider.getDocument(URI.createURI((String)diagnostic.getSource()));
            offSetStart = document.getOffSet(new Position(sPos.getLine() + 1, sPos.getCharacter() + 1));
            offSetEnd = document.getOffSet(new Position(ePos.getLine() + 1, ePos.getCharacter() + 1));
        }
        issue.setLineNumber(Integer.valueOf(sPos.getLine() + 1));
        issue.setColumn(Integer.valueOf(sPos.getCharacter() + 1));
        issue.setOffset(Integer.valueOf(offSetStart));
        issue.setLength(Integer.valueOf(offSetEnd - offSetStart));
        issue.setUriToProblem(uri);
        issue.setCode(diagnostic.getCode());
        issue.setType(CheckType.FAST);
        issue.setMessage(diagnostic.getMessage());
        return issue;
    }
}

