/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc.tokenizers;

import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocToken;
import org.eclipse.n4js.jsdoc.tokenizers.AbstractJSDocTokenizer;

public class RegionTokenizer
extends AbstractJSDocTokenizer {
    public final String startMarker;
    public final String endMarker;
    public final boolean nested;
    public final char escapeChar;
    public final boolean includeMarkers;
    public final boolean allowLinebreaks;

    public RegionTokenizer(String startMarker, String endMarker, boolean nested, char escapeChar, boolean includeMarkers, boolean allowLinebreaks) {
        this.startMarker = startMarker;
        this.endMarker = endMarker;
        this.nested = nested;
        this.escapeChar = escapeChar;
        this.includeMarkers = includeMarkers;
        this.allowLinebreaks = allowLinebreaks;
    }

    @Override
    public JSDocToken nextToken(JSDocCharScanner scanner) {
        int start = scanner.nextOffset();
        if (!this.findMarker(scanner, this.startMarker)) {
            return null;
        }
        StringBuilder strb = new StringBuilder();
        if (this.includeMarkers) {
            strb.append(this.startMarker);
        } else {
            start = scanner.nextOffset();
        }
        int nestedRegions = 0;
        int end = start;
        while (scanner.hasNext() && (this.allowLinebreaks || !scanner.skipped())) {
            if (scanner.peek() == this.escapeChar) {
                strb.append(scanner.next());
                if (!scanner.hasNext() || !this.allowLinebreaks && scanner.skipped()) continue;
                strb.append(scanner.next());
                end = scanner.offset();
                continue;
            }
            if (this.findMarker(scanner, this.startMarker)) {
                if (this.nested) {
                    ++nestedRegions;
                }
                strb.append(this.startMarker);
                continue;
            }
            if (this.findMarker(scanner, this.endMarker)) {
                if (nestedRegions == 0) {
                    if (this.includeMarkers) {
                        strb.append(this.endMarker);
                        end = scanner.offset();
                    }
                    return new JSDocToken(strb.toString(), start, end);
                }
                strb.append(this.endMarker);
                --nestedRegions;
                continue;
            }
            strb.append(scanner.next());
            end = scanner.offset();
        }
        return null;
    }

    private boolean findMarker(JSDocCharScanner scanner, String marker) {
        JSDocCharScanner.ScannerState state = scanner.saveState();
        int i = 0;
        while (i < marker.length()) {
            char ch;
            if (!scanner.hasNext() || i > 0 && scanner.skipped()) {
                scanner.restoreState(state);
                return false;
            }
            char expected = marker.charAt(i);
            if (expected != (ch = scanner.next())) {
                scanner.restoreState(state);
                return false;
            }
            ++i;
        }
        return true;
    }
}

