/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ide.codeActions;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;

public class JSONCodeActionService
implements ICodeActionService2 {
    public static final String INSTALL_NPM = "json.install.npm";
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public List<Either<Command, CodeAction>> getCodeActions(ICodeActionService2.Options options) {
        ArrayList<Either<Command, CodeAction>> result = new ArrayList<Either<Command, CodeAction>>();
        if (options.getCodeActionParams() != null && options.getCodeActionParams().getContext() != null) {
            List diagnostics = options.getCodeActionParams().getContext().getDiagnostics();
            for (Diagnostic diag : diagnostics) {
                Command cmd;
                if (!"NON_EXISTING_PROJECT".equals(diag.getCode()) || (cmd = this.createInstallNpmCommand(options, diag)) == null) continue;
                result.add((Either<Command, CodeAction>)Either.forLeft((Object)cmd));
            }
        }
        return result;
    }

    private Command createInstallNpmCommand(ICodeActionService2.Options options, Diagnostic diag) {
        EObject element = this.getEObject(options, diag);
        if (element instanceof NameValuePair) {
            NameValuePair pair = (NameValuePair)element;
            String projectName = pair.getName();
            String version = JSONModelUtils.asStringOrNull((JSONValue)pair.getValue());
            return new Command("Install npm package to workspace", INSTALL_NPM, Arrays.asList(projectName, version, options.getCodeActionParams().getTextDocument().getUri()));
        }
        return null;
    }

    private EObject getEObject(ICodeActionService2.Options options, Diagnostic diag) {
        Document doc = options.getDocument();
        XtextResource resource = options.getResource();
        return this.getEObject(doc, resource, diag.getRange());
    }

    private EObject getEObject(Document doc, XtextResource resource, Range range) {
        Position start = range.getStart();
        int startOffset = doc.getOffSet(start);
        return this.eObjectAtOffsetHelper.resolveContainedElementAt(resource, startOffset);
    }
}

