/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.regex.tests;

import org.eclipse.xtend2.lib.StringConcatenation;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractParserTests
extends Assert {
    public abstract void assertValid(CharSequence var1);

    @Test
    public void testHelloWorld() {
        this.assertValid("/Hello World/");
    }

    @Test
    public void testHelloWorldWithFlags() {
        this.assertValid("/Hello World/gsm");
    }

    @Test
    public void testNumber() {
        this.assertValid("/123/");
    }

    @Test
    public void testWildcard() {
        this.assertValid("/./");
    }

    @Test
    public void testEscapedWildcard() {
        this.assertValid("/\\./");
    }

    @Test
    public void testEscapedDecimal() {
        this.assertValid("/\\1/");
    }

    @Test
    public void testEscapedSpace() {
        this.assertValid("/\\ /");
    }

    @Test
    public void testAlternative() {
        this.assertValid("/a|b/");
    }

    @Test
    public void testEmptyAlternative_01() {
        this.assertValid("/a|/");
    }

    @Test
    public void testEmptyAlternative_02() {
        this.assertValid("/|a/");
    }

    @Test
    public void testEmptyAlternative_03() {
        this.assertValid("/a||b/");
    }

    @Test
    public void testAssertionLineStart() {
        this.assertValid("/^/");
    }

    @Test
    public void testAssertionLineEnd() {
        this.assertValid("/$/");
    }

    @Test
    public void testWordBoundary_01() {
        this.assertValid("/\\b/");
    }

    @Test
    public void testWordBoundary_02() {
        this.assertValid("/\\B/");
    }

    @Test
    public void testLookAhead_01() {
        this.assertValid("/(?=Hello World)/");
    }

    @Test
    public void testLookAhead_02() {
        this.assertValid("/(?!Hello World)/");
    }

    @Test
    public void testEmptyCharacterClass_01() {
        this.assertValid("/[]/");
    }

    @Test
    public void testEmptyCharacterClass_02() {
        this.assertValid("/[^]/");
    }

    @Test
    public void testDollarInCharacterClass() {
        this.assertValid("/[$]/");
    }

    @Test
    public void testDashInCharacterClass_01() {
        this.assertValid("/[-]/");
    }

    @Test
    public void testDashInCharacterClass_02() {
        this.assertValid("/[^-]/");
    }

    @Test
    public void testBracketInCharacterClass_01() {
        this.assertValid("/[[]/");
    }

    @Test
    public void testRangeInCharacterClass_01() {
        this.assertValid("/[a-z]/");
    }

    @Test
    public void testRangeInCharacterClass_02() {
        this.assertValid("/[aa-z]/");
    }

    @Test
    public void testRangeInCharacterClass_03() {
        this.assertValid("/[a-za]/");
    }

    @Test
    public void testRangeInCharacterClass_05() {
        this.assertValid("/[a-zA-Z1-z-]/");
    }

    @Test
    public void testRangeInCharacterClass_06() {
        this.assertValid("/[-a-zA-Z1-z-]/");
    }

    @Test
    public void testBackspaceInCharacterClass() {
        this.assertValid("/[\\b]/");
    }

    @Test
    public void testQuantifier_01() {
        this.assertValid("/123{123}/");
    }

    @Test
    public void testQuantifier_02() {
        this.assertValid("/123{123,}/");
    }

    @Test
    public void testQuantifier_03() {
        this.assertValid("/123{123,123}/");
    }

    @Test
    public void testQuantifier_04() {
        this.assertValid("/123{123}?/");
    }

    @Test
    public void testQuantifier_05() {
        this.assertValid("/123+/");
    }

    @Test
    public void testQuantifier_06() {
        this.assertValid("/123+?/");
    }

    @Test
    public void testQuantifier_07() {
        this.assertValid("/123*?/");
    }

    @Test
    public void testQuantifier_08() {
        this.assertValid("/123*/");
    }

    @Test
    public void testQuantifier_09() {
        this.assertValid("/123??/");
    }

    @Test
    public void testQuantifier_10() {
        this.assertValid("/123?/");
    }

    @Test
    public void testAssignWithWS() {
        this.assertValid("/,:=![,:=!]/");
    }

    @Test
    public void testIdentityEscape_01() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testIdentityEscape_02() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\u000A/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testIdentityEscape_03() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\u000D/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testIdentityEscape_04() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\u2028/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testIdentityEscape_05() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\u2029/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testLookBehind() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/(?<=$abc)def/");
        this.assertValid((CharSequence)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/^f.o(?<=foo)$/");
        this.assertValid((CharSequence)_builder_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("/^foo(?<!foo)$/");
        this.assertValid((CharSequence)_builder_2);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("/^f.o(?<!foo)$/");
        this.assertValid((CharSequence)_builder_3);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("/^foooo(?<=fo+)$/");
        this.assertValid((CharSequence)_builder_4);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("/^foooo(?<=fo*)$/");
        this.assertValid((CharSequence)_builder_5);
    }

    @Test
    public void testNamedGroups() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/(?<=(?<a>\\w){3})f/u");
        this.assertValid((CharSequence)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/(?<=(?<a>\\w)+)f/");
        this.assertValid((CharSequence)_builder_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("/((?<=\\w{3}))f/");
        this.assertValid((CharSequence)_builder_2);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("/(?<a>(?<=\\w{3}))f/");
        this.assertValid((CharSequence)_builder_3);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("/(?<!(?<a>\\d){3})f/u");
        this.assertValid((CharSequence)_builder_4);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("/(?<!(?<a>\\D){3})f|f/u");
        this.assertValid((CharSequence)_builder_5);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("/(?<a>\\k<a>\\w)../");
        this.assertValid((CharSequence)_builder_6);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("/\\k<a>(?<a>b)\\w\\k<a>/");
        this.assertValid((CharSequence)_builder_7);
    }

    @Test
    public void testExampleHandlebarsCompiler_01() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/(?:\\r\\n?|\\n).*/g");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_02() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/(?:\\r\\n?|\\n)/g");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_03() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\n/g");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_04() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\r?\\n?/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_05() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\\"/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_06() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\\\'/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_07() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\\\\\\\(?=(\\{\\{)))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_08() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:[^\\x00]*?(?=(\\{\\{)))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_09() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:[^\\x00]+)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_10() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:[^\\x00]{2,}?(?=(\\{\\{|$)))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_11() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:[\\s\\S]*?--\\}\\})/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_12() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{>)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_13() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{#)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_14() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{\\/)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_15() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{\\^)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_16() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{\\s*else\\b)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_17() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{\\{)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_18() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{&)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_19() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{!--)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_20() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{![\\s\\S]*?\\}\\})/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_21() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\{\\{)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_22() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:=)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_23() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\.(?=[}\\/ ]))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_24() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\.\\.)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_25() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:[\\/.])/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_26() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\s+)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_27() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\}\\}\\})/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_28() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\}\\})/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_29() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\"(\\\\[\"]|[^\"])*\")/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_30() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:'(\\\\[']|[^'])*')/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_31() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:@)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_32() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:true(?=[}\\s]))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_33() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:false(?=[}\\s]))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_34() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:-?[0-9]+(?=[}\\s]))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_35() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:[^\\s!\"#%-,\\.\\/;->@\\[-\\^`\\{-~]+(?=[=}\\s\\/.]))/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_36() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:\\[[^\\]]*\\])/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_37() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:.)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleHandlebarsCompiler_38() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^(?:$)/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExamplePrettify_01() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/^{{[#^>/]?\\s*[\\w.][^}]*}}/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleAce_01() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/\\/\\.\\//");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleAce_02() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/[^\\/]+\\/\\.\\.\\//");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testExampleAce_03() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/()??/");
        this.assertValid((CharSequence)_builder);
    }

    @Test
    public void testEqualsSign_01() {
        this.assertValid("/=/");
    }

    @Test
    public void testEqualsSign_02() {
        this.assertValid("/=/g");
    }

    @Test
    public void testWikipedia() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/(?<=\\.) {2,}(?=[A-Z])/");
        this.assertValid((CharSequence)_builder);
    }
}

