/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.semver;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.semver.Semver.HyphenVersionRange;
import org.eclipse.n4js.semver.Semver.SemverFactory;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.VersionComparator;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionRange;
import org.eclipse.n4js.semver.Semver.VersionRangeConstraint;
import org.eclipse.n4js.semver.SemverUtils;

class SemverConverter {
    SemverConverter() {
    }

    static List<SimpleVersion> simplify(VersionRange vr) {
        LinkedList<SimpleVersion> constraints = new LinkedList<SimpleVersion>();
        if (vr instanceof HyphenVersionRange) {
            HyphenVersionRange hvr = (HyphenVersionRange)vr;
            constraints.addAll(SemverConverter.simplify(hvr));
        }
        if (vr instanceof VersionRangeConstraint) {
            VersionRangeConstraint vrc = (VersionRangeConstraint)vr;
            for (SimpleVersion sv : vrc.getVersionConstraints()) {
                constraints.addAll(SemverConverter.simplify(sv));
            }
        }
        return constraints;
    }

    static List<SimpleVersion> simplify(SimpleVersion sv) {
        if (sv.isSpecific()) {
            return SemverConverter.simplifySpecific(sv);
        }
        if (sv.isCaret()) {
            return SemverConverter.simplifyCaret(sv);
        }
        if (sv.isTilde()) {
            return SemverConverter.simplifyTilde(sv);
        }
        return SemverConverter.copyAndPack(sv);
    }

    static List<SimpleVersion> simplify(HyphenVersionRange hvr) {
        return SemverConverter.simplifyHyphenRange(hvr);
    }

    private static List<SimpleVersion> simplifySpecific(SimpleVersion sv) {
        if (sv == null || sv.getNumber() == null) {
            return Collections.emptyList();
        }
        VersionNumber vn = sv.getNumber();
        if (vn.getMajor().isWildcard()) {
            SemverUtils.VersionNumberDescriptor vnDescr = new SemverUtils.VersionNumberDescriptor(0, 0, 0, null, null);
            return SemverConverter.pack(vnDescr, VersionComparator.GREATER_EQUALS);
        }
        int major = vn.getMajor().getNumber();
        if (vn.getMinor() == null || vn.getMinor().isWildcard()) {
            SemverUtils.VersionNumberDescriptor fromVND = new SemverUtils.VersionNumberDescriptor(major, 0, 0, null, null);
            SemverUtils.VersionNumberDescriptor toVND = new SemverUtils.VersionNumberDescriptor(major + 1, 0, 0, null, null);
            return SemverConverter.packRange(fromVND, VersionComparator.GREATER_EQUALS, toVND, VersionComparator.SMALLER);
        }
        int minor = vn.getMinor().getNumber();
        if (vn.getPatch() == null || vn.getPatch().isWildcard()) {
            SemverUtils.VersionNumberDescriptor fromVND = new SemverUtils.VersionNumberDescriptor(major, minor, 0, null, null);
            SemverUtils.VersionNumberDescriptor toVND = new SemverUtils.VersionNumberDescriptor(major, minor + 1, 0, null, null);
            return SemverConverter.packRange(fromVND, VersionComparator.GREATER_EQUALS, toVND, VersionComparator.SMALLER);
        }
        SemverUtils.VersionNumberDescriptor vnDescriptor = SemverUtils.getVersionNumberDescriptor(vn);
        return SemverConverter.packRange(vnDescriptor, vnDescriptor);
    }

    private static List<SimpleVersion> simplifyCaret(SimpleVersion sv) {
        VersionNumber caretVN = sv.getNumber();
        SemverUtils.VersionNumberDescriptor vnd = SemverUtils.getVersionNumberDescriptor(caretVN);
        SemverUtils.VersionNumberDescriptor vndCaretUpper = vnd.getCaretUpperBound();
        return SemverConverter.packRange(vnd, VersionComparator.GREATER_EQUALS, vndCaretUpper, VersionComparator.SMALLER);
    }

    private static List<SimpleVersion> simplifyTilde(SimpleVersion sv) {
        VersionNumber caretVN = sv.getNumber();
        SemverUtils.VersionNumberDescriptor vnd = SemverUtils.getVersionNumberDescriptor(caretVN);
        SemverUtils.VersionNumberDescriptor vndTildeUpper = vnd.getTildeUpperBound();
        return SemverConverter.packRange(vnd, VersionComparator.GREATER_EQUALS, vndTildeUpper, VersionComparator.SMALLER);
    }

    private static List<SimpleVersion> simplifyHyphenRange(HyphenVersionRange hvr) {
        SemverUtils.VersionNumberDescriptor vndFrom = SemverUtils.getVersionNumberDescriptor(hvr.getFrom());
        SemverUtils.VersionNumberDescriptor vndTo = SemverUtils.getVersionNumberDescriptor(hvr.getTo());
        VersionComparator toComparator = VersionComparator.SMALLER_EQUALS;
        if (vndTo.minor == null || vndTo.patch == null) {
            toComparator = VersionComparator.SMALLER;
        }
        return SemverConverter.packRange(vndFrom, VersionComparator.GREATER_EQUALS, vndTo, toComparator);
    }

    private static List<SimpleVersion> packRange(SemverUtils.VersionNumberDescriptor vndFrom, SemverUtils.VersionNumberDescriptor vndTo) {
        return SemverConverter.packRange(vndFrom, VersionComparator.GREATER_EQUALS, vndTo, VersionComparator.SMALLER_EQUALS);
    }

    private static List<SimpleVersion> packRange(SemverUtils.VersionNumberDescriptor vndFrom, VersionComparator vcFrom, SemverUtils.VersionNumberDescriptor vndTo, VersionComparator vcTo) {
        VersionNumber vnFrom = SemverUtils.createVersionNumber(vndFrom);
        VersionNumber vnTo = SemverUtils.createVersionNumber(vndTo);
        SimpleVersion svFrom = SemverFactory.eINSTANCE.createSimpleVersion();
        SimpleVersion svTo = SemverFactory.eINSTANCE.createSimpleVersion();
        svFrom.getComparators().add((Object)vcFrom);
        svTo.getComparators().add((Object)vcTo);
        svFrom.setNumber(vnFrom);
        svTo.setNumber(vnTo);
        return Lists.newArrayList((Object[])new SimpleVersion[]{svFrom, svTo});
    }

    private static List<SimpleVersion> copyAndPack(SimpleVersion sv) {
        SemverUtils.VersionNumberDescriptor verDescr = SemverUtils.getVersionNumberDescriptor(sv.getNumber());
        EList vComps = sv.getComparators();
        return SemverConverter.pack(verDescr, (VersionComparator[])vComps.toArray((Object[])new VersionComparator[vComps.size()]));
    }

    private static List<SimpleVersion> pack(SemverUtils.VersionNumberDescriptor verDescr, VersionComparator ... vc) {
        VersionNumber vnCopy = SemverUtils.createVersionNumber(verDescr);
        SimpleVersion svCopy = SemverFactory.eINSTANCE.createSimpleVersion();
        svCopy.getComparators().addAll(Arrays.asList(vc));
        svCopy.setNumber(vnCopy);
        return Lists.newArrayList((Object[])new SimpleVersion[]{svCopy});
    }
}

