/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources.sessions;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.n4js.tester.events.SessionStartedEvent;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.server.HttpConstants;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;
import org.eclipse.n4js.tester.server.resources.ContentType;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.Resource;
import org.eclipse.n4js.tester.server.resources.sessions.SessionResource;

@Resource(path="/{sessionId}/start/", method={HttpMethod.POST}, requestContentType={ContentType.START_SESSION})
public class StartSessionResource
extends SessionResource {
    private static final String PROPERTIES = "properties";
    @Inject
    private ObjectMapper mapper;

    @Override
    protected TestEvent createEvent(String sessionId, String body) throws ClientResourceException {
        HashMap values = Maps.newHashMap();
        try {
            if (!Strings.isNullOrEmpty((String)body)) {
                values.putAll((Map)this.mapper.readValue(body, Map.class));
            }
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
        }
        catch (IOException e) {
            throw new ClientResourceException(400);
        }
        final HashMap properties = Maps.newHashMap();
        if (values.get(PROPERTIES) != null) {
            if (!(values.get(PROPERTIES) instanceof Map)) {
                throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
            }
            ((Map)values.get(PROPERTIES)).entrySet().forEach(new Consumer<Map.Entry<?, ?>>(){

                @Override
                public void accept(Map.Entry<?, ?> entry) {
                    properties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            });
        }
        return new SessionStartedEvent(sessionId, properties);
    }

    @Override
    protected boolean sessionExists(String sessionId) {
        return true;
    }
}

