/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.search;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.ts.ui.search.LabelledReferenceDescription;
import org.eclipse.n4js.ui.N4JSHierarchicalNameComputerHelper;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.search.N4JSReferenceQueryExecutor;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.DelegatingReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceAcceptor;
import org.eclipse.xtext.util.IAcceptor;

public class LabellingReferenceFinder
extends DelegatingReferenceFinder {
    @Inject
    private N4JSLabelProvider labelProvider;

    protected IReferenceFinder.Acceptor toAcceptor(IAcceptor<IReferenceDescription> acceptor) {
        return new ReferenceAcceptor(acceptor, this.getResourceServiceProviderRegistry()){

            public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                if (N4JSReferenceQueryExecutor.ignoreNamedImportSpecifier && source instanceof NamedImportSpecifier) {
                    return;
                }
                EObject displayObject = LabellingReferenceFinder.this.calculateDisplayEObject(source);
                String logicallyQualifiedDisplayName = N4JSHierarchicalNameComputerHelper.calculateHierarchicalDisplayName(displayObject, (LabelProvider)LabellingReferenceFinder.this.labelProvider, false);
                ICompositeNode srcNode = NodeModelUtils.getNode((EObject)source);
                int line = srcNode.getStartLine();
                LabelledReferenceDescription description = new LabelledReferenceDescription(source, displayObject, sourceURI, targetOrProxy, targetURI, eReference, index, logicallyQualifiedDisplayName, line);
                this.accept((IReferenceDescription)description);
            }
        };
    }

    private EObject calculateDisplayEObject(EObject source) {
        EObject displayObject = source;
        while (!N4JSHierarchicalNameComputerHelper.isShowable(displayObject)) {
            displayObject = displayObject.eContainer();
        }
        return displayObject;
    }
}

