/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.n4js.utils.io.IDirectoryDiffAcceptor;

public abstract class FileUtils {
    private FileUtils() {
    }

    private static final String getTempDirValue() {
        return (String)Preconditions.checkNotNull((Object)StandardSystemProperty.JAVA_IO_TMPDIR.value(), (Object)"Null for java.io.tmpdir system property.");
    }

    public static Path getTempFolder() {
        File file = new File(FileUtils.getTempDirValue());
        if (!file.exists() || !file.canWrite()) {
            throw new RuntimeException("Cannot access temporary directory under: " + FileUtils.getTempDirValue());
        }
        return file.toPath();
    }

    public static Path createDirectory(Path parent, String folderName) {
        File file = new File(parent.toFile(), folderName);
        if (!file.exists() && !file.mkdir()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + " with " + folderName + ".");
        }
        file.deleteOnExit();
        return file.toPath();
    }

    public static Path createNestedDirectory(Path parent, String nestedPath) {
        if (!parent.toFile().isDirectory()) {
            throw new RuntimeException("Invalid parent at " + parent + ".");
        }
        Path desiredPath = parent.resolve(nestedPath);
        File file = new File(desiredPath.toUri());
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + " with " + nestedPath + ".");
        }
        file.deleteOnExit();
        return file.toPath();
    }

    public static Path createDirectory(Path parent) {
        File file;
        try {
            file = Files.createTempDirectory(parent, null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!file.exists()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + ".");
        }
        file.deleteOnExit();
        return file.toPath();
    }

    public static Path createTempDirectory() {
        return FileUtils.createTempDirectory(null);
    }

    public static Path createTempDirectory(String prefix) {
        File child;
        File parent = new File(FileUtils.getTempDirValue());
        if (!parent.exists() || !parent.canWrite()) {
            throw new RuntimeException("Cannot access temporary directory under: " + FileUtils.getTempDirValue());
        }
        try {
            child = Files.createTempDirectory(parent.toPath(), prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!child.exists()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + ".");
        }
        child.deleteOnExit();
        return child.toPath();
    }

    /*
     * Exception decompiling
     */
    public static long compareFiles(File expectedFile, File actualFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void compareDirectories(File expectedRoot, File actualRoot, IDirectoryDiffAcceptor acceptor) throws IOException {
        if (!expectedRoot.exists() || !expectedRoot.isDirectory()) {
            throw new IllegalArgumentException("expectedRoot does not exist or is not a directory");
        }
        if (!actualRoot.exists() || !actualRoot.isDirectory()) {
            throw new IllegalArgumentException("actualRoot does not exist or is not a directory");
        }
        Path expectedRootPath = expectedRoot.toPath();
        Path actualRootPath = actualRoot.toPath();
        Set expectedContents = Files.walk(expectedRootPath, new FileVisitOption[0]).collect(Collectors.toSet());
        Files.walk(actualRootPath, new FileVisitOption[0]).forEach(actualPath -> {
            Path relativePath = actualRootPath.relativize((Path)actualPath);
            Path expectedPath = expectedRootPath.resolve(relativePath);
            if (expectedContents.remove(expectedPath)) {
                File expectedFile = expectedPath.toFile();
                File actualFile = actualPath.toFile();
                if (expectedFile.isDirectory()) {
                    if (!actualFile.isDirectory()) {
                        acceptor.fileInsteadOfDirectory(relativePath);
                    }
                } else if (actualFile.isDirectory()) {
                    acceptor.directoryInsteadOfFile(relativePath);
                } else {
                    long diffPos = FileUtils.compareFiles(expectedFile, actualFile);
                    if (diffPos == -1L) {
                        acceptor.differentLength(relativePath);
                    } else if (diffPos >= 0L) {
                        acceptor.differentContent(relativePath, diffPos);
                    }
                }
            } else {
                acceptor.unexpected(relativePath);
            }
        });
        expectedContents.stream().forEach(expectedPath -> {
            Path relativePath = expectedRootPath.relativize((Path)expectedPath);
            acceptor.missing(relativePath);
        });
    }

    public static void deleteFileOrFolder(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] childFildes = file.listFiles();
            int i = 0;
            while (i < childFildes.length) {
                FileUtils.deleteFileOrFolder(childFildes[i]);
                ++i;
            }
        }
        file.delete();
    }

    public static void onExitDeleteFileOrFolder(File file) {
        file.deleteOnExit();
        if (file.isDirectory()) {
            File[] childFildes = file.listFiles();
            int i = 0;
            while (i < childFildes.length) {
                FileUtils.onExitDeleteFileOrFolder(childFildes[i]);
                ++i;
            }
        }
    }

    public static void cleanFolder(File folder) {
        if (folder.isDirectory()) {
            File[] childFiles = folder.listFiles();
            int i = 0;
            while (i < childFiles.length) {
                FileUtils.deleteFileOrFolder(childFiles[i]);
                ++i;
            }
        }
    }

    public static String normalize(String path) {
        String normalized = null;
        if (path != null) {
            normalized = Paths.get(path, new String[0]).normalize().toString();
        }
        return normalized;
    }

    public static String normalizeToDotWhenEmpty(String path) {
        String normalized = FileUtils.normalize(path);
        if (normalized != null && normalized.isEmpty()) {
            normalized = ".";
        }
        return normalized;
    }
}

