/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.contentassist;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Pair;

public class XIdeContentProposalAcceptor
implements IIdeContentProposalAcceptor {
    private static final int DEFAULT_PROPOSALS_LIMIT = 1000;
    private final CancelIndicator cancelIndicator;
    private final Map<String, Pair<Integer, ContentAssistEntry>> entries = new HashMap<String, Pair<Integer, ContentAssistEntry>>();
    private final Comparator<Pair<Integer, ContentAssistEntry>> comparator = Comparator.comparingInt(Pair::getKey).thenComparing(p -> ((ContentAssistEntry)p.getValue()).toString(), String.CASE_INSENSITIVE_ORDER);

    XIdeContentProposalAcceptor(CancelIndicator cancelIndicator) {
        this.cancelIndicator = cancelIndicator;
    }

    public void accept(ContentAssistEntry entry, int priority) {
        if (entry != null) {
            if (entry.getProposal() == null) {
                throw new IllegalArgumentException("proposal must not be null.");
            }
            String entryString = entry.toString();
            if (this.entries.containsKey(entryString)) {
                Pair<Integer, ContentAssistEntry> existingProposal = this.entries.get(entryString);
                priority = (Integer)existingProposal.getKey();
            }
            this.entries.put(entryString, (Pair<Integer, ContentAssistEntry>)Pair.of((Object)priority, (Object)entry));
        }
    }

    public boolean canAcceptMoreProposals() {
        boolean result;
        boolean bl = result = !this.cancelIndicator.isCanceled();
        if (!result) {
            System.err.println("Cancelled");
        }
        return result && this.entries.size() < 1000;
    }

    public Iterable<ContentAssistEntry> getEntries() {
        ImmutableList sortedList = FluentIterable.from(this.entries.values()).toSortedList(this.comparator);
        return FluentIterable.from((Iterable)sortedList).transform(Pair::getValue);
    }
}

