/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.N4JSParseHelper;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSTestHelper {
    @Inject
    private N4JSParseHelper parseHelper;
    @Inject
    private ValidationTestHelper validationTestHelper;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;

    public Script parseAndValidateSuccessfully(CharSequence code) throws Exception {
        Script script = this.parseHelper.parseN4js(code);
        this.parseHelper.assertNoParseErrors(script);
        this.validationTestHelper.assertNoErrors((EObject)script);
        return script;
    }

    public ResourceSet parseAndValidateSuccessfullyMany(Iterable<Pair<String, String>> fileNamesToCode) throws Exception {
        XtextResourceSet rs = (XtextResourceSet)this.resourceSetProvider.get();
        for (Pair<String, String> pair : fileNamesToCode) {
            String fileName = (String)pair.getKey();
            String code = (String)pair.getValue();
            Script script = this.parseWithFileExtensionFromURI(code, URI.createURI((String)fileName), (ResourceSet)rs);
            this.parseHelper.assertNoParseErrors(script);
        }
        for (Resource res : rs.getResources()) {
            if (!(res instanceof N4JSResource)) continue;
            Script script = ((N4JSResource)res).getScript();
            this.validationTestHelper.assertNoErrors((EObject)script);
        }
        return rs;
    }

    private Script parseWithFileExtensionFromURI(CharSequence text, URI uriToUse, ResourceSet resourceSetToUse) throws Exception {
        String fileExtensionToUse = uriToUse.fileExtension();
        if (fileExtensionToUse == null) {
            throw new IllegalArgumentException("given URI does not have a file extension");
        }
        String oldExtension = this.parseHelper.fileExtension;
        try {
            this.parseHelper.fileExtension = fileExtensionToUse;
            Script script = (Script)this.parseHelper.parse(text, uriToUse, resourceSetToUse);
            return script;
        }
        finally {
            this.parseHelper.fileExtension = oldExtension;
        }
    }
}

