/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.codegen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.n4js.tests.codegen.Classifier;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Module {
    private final String name;
    private final String fExtension;
    private List<Classifier<?>> classifiers;
    private String contents;
    private Map<String, List<String>> imports;

    public Module(String name) {
        this(name, "n4js");
    }

    public Module(String name, String fExtension) {
        this.name = Objects.requireNonNull(name);
        this.fExtension = Objects.requireNonNull(fExtension);
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.fExtension;
    }

    public Module setContents(String contents) {
        this.contents = contents;
        return this;
    }

    public Module addClassifier(Classifier<?> classifier) {
        if (this.classifiers == null) {
            this.classifiers = CollectionLiterals.newLinkedList();
        }
        this.classifiers.add(Objects.requireNonNull(classifier));
        return this;
    }

    public Module addImport(String importedType, Module sourceModule) {
        return this.addImport(importedType, sourceModule.name);
    }

    public Module addImport(Classifier<?> importedType, Module sourceModule) {
        return this.addImport(importedType.getName(), sourceModule);
    }

    public Module addImport(String importedType, String sourceModule) {
        LinkedList importedTypesForModule;
        if (this.imports == null) {
            this.imports = CollectionLiterals.newHashMap();
        }
        if ((importedTypesForModule = this.imports.get(Objects.requireNonNull(sourceModule))) == null) {
            importedTypesForModule = CollectionLiterals.newLinkedList();
            this.imports.put(sourceModule, importedTypesForModule);
        }
        importedTypesForModule.add(Objects.requireNonNull(importedType));
        return this;
    }

    public void create(File parentDirectory) {
        try {
            boolean _not_1;
            boolean _not;
            Objects.requireNonNull(parentDirectory);
            boolean _exists = parentDirectory.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                throw new IOException("Directory '" + parentDirectory + "' does not exist");
            }
            boolean _isDirectory = parentDirectory.isDirectory();
            boolean bl2 = _not_1 = !_isDirectory;
            if (_not_1) {
                throw new IOException("'" + parentDirectory + "' is not a directory");
            }
            File filePath = new File(parentDirectory, String.valueOf(this.name) + "." + this.fExtension);
            try (OutputStreamWriter out = null;){
                FileWriter _fileWriter = new FileWriter(filePath);
                out = _fileWriter;
                out.write(this.generate().toString());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generate() {
        boolean _hasContents;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasImports = this.hasImports();
        if (_hasImports) {
            CharSequence _generateImports = this.generateImports();
            _builder.append((Object)_generateImports);
            _builder.newLineIfNotEmpty();
        }
        if (_hasContents = this.hasContents()) {
            _builder.append(this.contents);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _hasClassifiers = this.hasClassifiers();
            if (_hasClassifiers) {
                CharSequence _generateClassifiers = this.generateClassifiers();
                _builder.append((Object)_generateClassifiers);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateImports() {
        StringConcatenation _builder = new StringConcatenation();
        Set<Map.Entry<String, List<String>>> _entrySet = this.imports.entrySet();
        for (Map.Entry<String, List<String>> entry : _entrySet) {
            _builder.append("import { ");
            List<String> _value = entry.getValue();
            boolean _hasElements = false;
            for (String type : _value) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append(type);
            }
            _builder.append(" } from \"");
            String _key = entry.getKey();
            _builder.append(_key);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateClassifiers() {
        StringConcatenation _builder = new StringConcatenation();
        for (Classifier<?> classifier : this.classifiers) {
            CharSequence _generate = classifier.generate();
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private boolean hasClassifiers() {
        return this.classifiers != null && !this.classifiers.isEmpty();
    }

    private boolean hasImports() {
        return this.imports != null && !this.imports.isEmpty();
    }

    private boolean hasContents() {
        return this.contents != null && !this.contents.isEmpty();
    }
}

