/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.codegen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.tests.codegen.Module;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Project {
    private final String projectName;
    private final String vendorId;
    private final String vendorName;
    private final List<SourceFolder> sourceFolders = CollectionLiterals.newLinkedList();
    private final List<Project> projectDependencies = CollectionLiterals.newLinkedList();
    private final Map<String, Project> nodeModuleProjects = CollectionLiterals.newHashMap();
    private ProjectType projectType;
    private String projectVersion = "1.0.0";
    private String outputFolder = "src-gen";
    private String projectDescriptionContent = null;

    public Project(String projectName, String vendorId, String vendorName) {
        this(projectName, vendorId, vendorName, ProjectType.LIBRARY);
    }

    public Project(String projectName, String vendorId, String vendorName, ProjectType projectType) {
        this.projectName = Objects.requireNonNull(projectName);
        this.vendorId = Objects.requireNonNull(vendorId);
        this.vendorName = Objects.requireNonNull(vendorName);
        this.projectType = Objects.requireNonNull(projectType);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Project setType(ProjectType projectType) {
        this.projectType = projectType;
        return this;
    }

    public String getVersion() {
        return this.projectVersion;
    }

    public Project setVersion(String projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }

    public Project setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
        return this;
    }

    public Project setProjectDescriptionContent(String projectDescriptionContent) {
        this.projectDescriptionContent = projectDescriptionContent;
        return this;
    }

    public String getProjectDescriptionContent() {
        return this.projectDescriptionContent;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public SourceFolder createSourceFolder(String name) {
        SourceFolder result = new SourceFolder(name);
        this.addSourceFolder(result);
        return result;
    }

    public Project addSourceFolder(SourceFolder sourceFolder) {
        this.sourceFolders.add(Objects.requireNonNull(sourceFolder));
        return this;
    }

    public List<SourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    public Project addProjectDependency(Project projectDependency) {
        this.projectDependencies.add(Objects.requireNonNull(projectDependency));
        return this;
    }

    public List<Project> getProjectDependencies() {
        return this.projectDependencies;
    }

    public void addNodeModuleProject(Project project) {
        this.nodeModuleProjects.put(project.projectName, project);
        this.addProjectDependency(project);
    }

    public Project getNodeModuleProject(String projectName) {
        return this.nodeModuleProjects.get(projectName);
    }

    public String generate() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.projectDescriptionContent);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(this.projectDescriptionContent);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _not_3;
            boolean _not_2;
            boolean _not_1;
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"name\": \"");
            _builder.append(this.projectName, "\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\"version\": \"");
            _builder.append(this.projectVersion, "\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\"n4js\": {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\"vendorId\": \"");
            _builder.append(this.vendorId, "\t\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\"vendorName\": \"");
            _builder.append(this.vendorName, "\t\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\"projectType\": \"");
            String _projectTypeToString = Project.projectTypeToString(this.projectType);
            _builder.append(_projectTypeToString, "\t\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)this.outputFolder);
            boolean bl2 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                _builder.append("\"output\": \"");
                _builder.append(this.outputFolder, "\t\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(this.sourceFolders);
            boolean bl3 = _not_2 = !_isNullOrEmpty_2;
            if (_not_2) {
                _builder.append(",\"sources\": {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t\t");
                _builder.append("\"source\": [");
                _builder.newLine();
                boolean _hasElements = false;
                for (SourceFolder sourceFolder : this.sourceFolders) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t\t\t\t\t");
                    }
                    _builder.append("\t\t");
                    _builder.append("\t\t\t");
                    _builder.append("\"");
                    _builder.append(sourceFolder.name, "\t\t\t\t\t");
                    _builder.append("\"");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("\t\t");
                _builder.append("]");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("},");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"dependencies\": {");
            _builder.newLine();
            boolean _isNullOrEmpty_3 = IterableExtensions.isNullOrEmpty(this.projectDependencies);
            boolean bl4 = _not_3 = !_isNullOrEmpty_3;
            if (_not_3) {
                boolean _hasElements_1 = false;
                for (Project dep : this.projectDependencies) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t\t\t");
                    }
                    _builder.append("\t\t\t");
                    _builder.append("\"");
                    _builder.append(dep.projectName, "\t\t\t");
                    _builder.append("\": \"*\"");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder.toString();
    }

    private static String projectTypeToString(ProjectType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case API: {
                    _switchResult = "api";
                    break;
                }
                case APPLICATION: {
                    _switchResult = "application";
                    break;
                }
                case LIBRARY: {
                    _switchResult = "library";
                    break;
                }
                case PROCESSOR: {
                    _switchResult = "processor";
                    break;
                }
                case RUNTIME_ENVIRONMENT: {
                    _switchResult = "runtimeEnvironment";
                    break;
                }
                case RUNTIME_LIBRARY: {
                    _switchResult = "runtimeLibrary";
                    break;
                }
                case TEST: {
                    _switchResult = "test";
                    break;
                }
                case PLAINJS: {
                    _switchResult = "plainjs";
                    break;
                }
                case VALIDATION: {
                    _switchResult = "validation";
                    break;
                }
                case DEFINITION: {
                    _switchResult = "definition";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public File create(Path parentDirectoryPath) {
        try {
            boolean _not_2;
            boolean _not_1;
            boolean _not;
            File parentDirectory = Objects.requireNonNull(parentDirectoryPath).toFile();
            boolean _exists = parentDirectory.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                throw new IOException("'" + parentDirectory + "' does not exist");
            }
            boolean _isDirectory = parentDirectory.isDirectory();
            boolean bl2 = _not_1 = !_isDirectory;
            if (_not_1) {
                throw new IOException("'" + parentDirectory + "' is not a directory");
            }
            File projectDirectory = new File(parentDirectory, this.projectName);
            boolean _exists_1 = projectDirectory.exists();
            if (_exists_1) {
                FileDeleter.delete((File)projectDirectory);
            }
            projectDirectory.mkdirs();
            this.createProjectDescriptionFile(projectDirectory);
            this.createModules(projectDirectory);
            boolean _isEmpty = this.nodeModuleProjects.isEmpty();
            boolean bl3 = _not_2 = !_isEmpty;
            if (_not_2) {
                File nodeModulesDirectory = new File(projectDirectory, "node_modules");
                boolean _exists_2 = nodeModulesDirectory.exists();
                if (_exists_2) {
                    FileDeleter.delete((File)nodeModulesDirectory);
                }
                nodeModulesDirectory.mkdir();
                this.createNodeModuleProjects(nodeModulesDirectory);
            }
            return projectDirectory;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void createProjectDescriptionFile(File parentDirectory) {
        try {
            File filePath = new File(parentDirectory, "package.json");
            try (OutputStreamWriter out = null;){
                FileWriter _fileWriter = new FileWriter(filePath);
                out = _fileWriter;
                out.write(this.generate().toString());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void createModules(File parentDirectory) {
        for (SourceFolder sourceFolder : this.sourceFolders) {
            sourceFolder.create(parentDirectory);
        }
    }

    private void createNodeModuleProjects(File parentDirectory) {
        Collection<Project> _values = this.nodeModuleProjects.values();
        for (Project nodeModuleProject : _values) {
            nodeModuleProject.create(parentDirectory.toPath());
        }
    }

    public static class SourceFolder {
        private final String name;
        private final List<Module> modules = CollectionLiterals.newLinkedList();

        public SourceFolder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public SourceFolder addModule(Module module) {
            this.modules.add(Objects.requireNonNull(module));
            return this;
        }

        public List<Module> getModules() {
            return this.modules;
        }

        public void create(File parentDirectory) {
            try {
                boolean _not_1;
                boolean _not;
                Objects.requireNonNull(parentDirectory);
                boolean _exists = parentDirectory.exists();
                boolean bl = _not = !_exists;
                if (_not) {
                    throw new IOException("Directory '" + parentDirectory + "' does not exist");
                }
                boolean _isDirectory = parentDirectory.isDirectory();
                boolean bl2 = _not_1 = !_isDirectory;
                if (_not_1) {
                    throw new IOException("'" + parentDirectory + "' is not a directory");
                }
                File sourceFolder = new File(parentDirectory, this.name);
                sourceFolder.mkdir();
                for (Module module : this.modules) {
                    module.create(sourceFolder);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }
}

