/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.codegen;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.tests.codegen.Project;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class YarnWorkspaceProject
extends Project {
    private final Map<String, Project> projects = CollectionLiterals.newHashMap();
    private final String workspacesFolderName;

    public YarnWorkspaceProject(String projectName, String vendorId, String vendorName) {
        this(projectName, vendorId, vendorName, "packages");
    }

    public YarnWorkspaceProject(String projectName, String vendorId, String vendorName, String workspacesFolderName) {
        super(projectName, vendorId, vendorName, ProjectType.LIBRARY);
        this.workspacesFolderName = workspacesFolderName;
    }

    public void addProject(Project project) {
        this.projects.put(project.getProjectName(), project);
    }

    public Project getProject(String projectName) {
        return this.projects.get(projectName);
    }

    @Override
    public String generate() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"name\": \"");
        String _projectName = this.getProjectName();
        _builder.append(_projectName, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"version\": \"");
        String _version = this.getVersion();
        _builder.append(_version, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"private\": true,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"workspaces\": [");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("\"");
        _builder.append(this.workspacesFolderName, "\t    ");
        _builder.append("/*\"");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("],");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"dependencies\": {");
        _builder.newLine();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.getProjectDependencies());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            List<Project> _projectDependencies = this.getProjectDependencies();
            boolean _hasElements = false;
            for (Project dep : _projectDependencies) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t");
                }
                _builder.append("\t\t\t");
                _builder.append("\"");
                String _projectName_1 = dep.getProjectName();
                _builder.append(_projectName_1, "\t\t\t");
                _builder.append("\": \"*\"");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    @Override
    public File create(Path parentDirectoryPath) {
        try {
            super.create(parentDirectoryPath);
            File parentDirectory = Objects.requireNonNull(parentDirectoryPath).toFile();
            String _projectName = this.getProjectName();
            File projectDirectory = new File(parentDirectory, _projectName);
            String _projectName_1 = this.getProjectName();
            File _file = new File(parentDirectory, _projectName_1);
            File workspacesDirectory = new File(_file, this.workspacesFolderName);
            boolean _exists = workspacesDirectory.exists();
            if (_exists) {
                FileDeleter.delete((File)workspacesDirectory);
            }
            workspacesDirectory.mkdirs();
            this.createWorkspaceProjects(workspacesDirectory);
            return projectDirectory;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void createWorkspaceProjects(File parentDirectory) {
        Collection<Project> _values = this.projects.values();
        for (Project project : _values) {
            project.create(parentDirectory.toPath());
        }
    }
}

