/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.postprocessing.ASTMetaInfoUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class N4JSVariableValidator
extends AbstractN4JSDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkVariableDeclaration(VariableDeclaration varDecl) {
        boolean _tripleNotEquals;
        Expression _expression = varDecl.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            List<IdentifierRef> refs = N4JSVariableValidator.collectIdentifierRefsTo((EObject)varDecl.getExpression(), varDecl, CollectionLiterals.newArrayList());
            for (IdentifierRef currRef : refs) {
                String message = IssueCodes.getMessageForAST_VAR_DECL_RECURSIVE(varDecl.getName());
                this.addIssue(message, (EObject)currRef, null, "AST_VAR_DECL_RECURSIVE", new String[0]);
            }
        }
    }

    @Check
    public void checkUnusedVariables(VariableDeclaration varDecl) {
        if (varDecl instanceof ExportedVariableDeclaration) {
            return;
        }
        boolean _isEmpty = ASTMetaInfoUtils.getLocalVariableReferences(varDecl).isEmpty();
        if (_isEmpty) {
            String message = IssueCodes.getMessageForCFG_LOCAL_VAR_UNUSED(varDecl.getName());
            this.addIssue(message, (EObject)varDecl, (EStructuralFeature)this.findNameFeature((EObject)varDecl).getValue(), "CFG_LOCAL_VAR_UNUSED", new String[0]);
        }
    }

    private static List<IdentifierRef> collectIdentifierRefsTo(EObject astNode, VariableDeclaration varDecl, List<IdentifierRef> result) {
        if (astNode instanceof N4ClassExpression && !N4JSVariableValidator.isInstantiatedOrCalled(astNode)) {
            return result;
        }
        if (astNode instanceof FunctionExpression && !N4JSVariableValidator.isInstantiatedOrCalled(astNode)) {
            return result;
        }
        Object _xifexpression = null;
        _xifexpression = varDecl instanceof ExportedVariableDeclaration ? ((ExportedVariableDeclaration)varDecl).getDefinedVariable() : varDecl;
        VariableDeclaration targetForReferencesToVarDecl = _xifexpression;
        if (astNode instanceof IdentifierRef) {
            boolean _tripleEquals;
            IdentifiableElement _id = ((IdentifierRef)astNode).getId();
            boolean bl = _tripleEquals = _id == targetForReferencesToVarDecl;
            if (_tripleEquals) {
                result.add((IdentifierRef)astNode);
            }
        }
        EList _eContents = astNode.eContents();
        for (EObject child : _eContents) {
            N4JSVariableValidator.collectIdentifierRefsTo(child, varDecl, result);
        }
        return result;
    }

    public static boolean containsIdentifierRefsTo(EObject astNode, VariableDeclaration varDecl) {
        boolean _isEmpty = N4JSVariableValidator.collectIdentifierRefsTo(astNode, varDecl, CollectionLiterals.newArrayList()).isEmpty();
        return !_isEmpty;
    }

    private static boolean isInstantiatedOrCalled(EObject astNode) {
        EObject curr = astNode;
        while (curr.eContainer() instanceof ParenExpression) {
            curr = curr.eContainer();
        }
        EObject parent = curr.eContainer();
        boolean _switchResult = false;
        boolean _matched = false;
        if (parent instanceof NewExpression) {
            _matched = true;
            Expression _callee = ((NewExpression)parent).getCallee();
            boolean bl = _switchResult = _callee == curr;
        }
        if (!_matched && parent instanceof ParameterizedCallExpression) {
            _matched = true;
            Expression _target = ((ParameterizedCallExpression)parent).getTarget();
            boolean bl = _switchResult = _target == curr;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }
}

