/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.apache.log4j.Logger;
import org.eclipse.n4js.antlr.N4AntlrGeneratorFragment2;
import org.eclipse.n4js.antlr.n4js.NoLineTerminatorHandlingInjector;
import org.eclipse.n4js.antlr.replacements.Replacements;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;
import org.eclipse.xtext.xtext.FlattenedGrammarAccess;
import org.eclipse.xtext.xtext.RuleFilter;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.grammarAccess.GrammarAccessExtensions;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GeneratedJavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.xtext.generator.parser.antlr.ContentAssistGrammarNaming;
import org.eclipse.xtext.xtext.generator.parser.antlr.GrammarNaming;
import org.eclipse.xtext.xtext.generator.parser.antlr.XtextAntlrGeneratorFragment2;
import org.eclipse.xtext.xtext.generator.util.SyntheticTerminalDetector;

/**
 * Customization of the {@link XtextAntlrGeneratorFragment2} applying some massaging
 *  of the Parser implementation generated by ANTLR.
 */
@Log
@SuppressWarnings("all")
public class N4JSAntlrGeneratorFragment2 extends N4AntlrGeneratorFragment2 {
  @Inject
  private GrammarNaming productionNaming;
  
  @Override
  protected void generateProductionGrammar() {
    super.generateProductionGrammar();
    @Extension
    final GrammarNaming naming = this.productionNaming;
    String _path = this.getProjectConfig().getRuntime().getSrcGen().getPath();
    String _plus = (_path + "/");
    String _grammarFileName = naming.getParserGrammar(this.getGrammar()).getGrammarFileName();
    final String absoluteParserFileName = (_plus + _grammarFileName);
    this.massageGrammar(absoluteParserFileName, this.getCodeConfig().getEncoding());
  }
  
  private void massageGrammar(final String absoluteParserFileName, final String encoding) {
    try {
      final String javaFile = absoluteParserFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
      File _file = new File(javaFile);
      final String content = Files.toString(_file, Charset.forName(encoding));
      final String normalizedContent = content.replace("\r\n", "\n");
      final String newContent = this.fixIdentifierAsKeywordWithEOLAwareness(normalizedContent);
      boolean _equals = normalizedContent.equals(newContent);
      if (_equals) {
        N4JSAntlrGeneratorFragment2.LOG.warn(("Replacement not found in " + javaFile));
      }
      boolean _equals_1 = content.equals(newContent);
      boolean _not = (!_equals_1);
      if (_not) {
        File _file_1 = new File(javaFile);
        Files.write(newContent, _file_1, Charset.forName(encoding));
      }
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        throw new RuntimeException(e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  protected String getParserFileNameSuffix() {
    return ".java";
  }
  
  protected String getLexerFileNameSuffix() {
    return ".java";
  }
  
  /**
   * This is part of the {@link NoLineTerminatorHandlingInjector}, fixing a problem with line-ending aware tokens like
   * 'async'.
   * <p>
   * The problem likely (I do not know for sure) is as follows: In some cases, keywords are not reserved and may be
   * used as identifiers as well. Examples are some N4JS specific keywords such as 'abstract' or 'project'. Now, these
   * terminals can only occur as keywords in some very specific locations. This is different for 'async': Since it can
   * be used as a modifier for function expressions or arrow functions, it can occur almost everywhere in the code. In
   * order to distinguish keyword 'async' from its use as an identifier, no line terminator must follow in the first
   * case. There are actually two problems: First, it is not directly possible to define "no line terminator here" in
   * the Xtext grammar. Second, checking for the line terminator and the whole keyword vs. identifier handling seems
   * to disable automatic semicolon insertation, at least partially. The result of the later problem is pretty bad:
   * The parser may recognize an expression statement or identifier, but in the AST null is inserted instead. I assume
   * this is because the ANTLR parser is not aware of the line-termintor-handling which partially disables its
   * backtracking.
   * <p>
   * The solution is three fold:
   * <ol>
   * <li>In {@link NoLineTerminatorHandlingInjector} we rewrite the lexer rule to always reject the dummy token we
   * need for the parser rule
   * <li>Here, we rewrite the parser rule to fail if a line terminator was found
   * <li>Also, we adapt the primary expression rule, to continue in case an 'async' keyword has been found.
   * </ol>
   * Some remarks on debugging: Note that the stack trace (and the debugger) have a limit of 64k lines. Then, the
   * counter starts again! So breakpoints and stepping may be useless if you want to debug code after 64k lines.
   * 
   * TODO IDE-2406 clarify/document design decision
   */
  private String fixIdentifierAsKeywordWithEOLAwareness(final String normalizedContent) {
    final String c1 = Replacements.applyReplacement(normalizedContent, "ruleNoLineTerminator.java.replacement");
    final String c2 = Replacements.applyReplacement(c1, "rulePrimaryExpression.java.replacement");
    return c2;
  }
  
  @Inject
  private ReflectExtensions reflector;
  
  @Inject
  @Extension
  private GrammarAccessExtensions grammarUtil;
  
  @Inject
  @Extension
  private SyntheticTerminalDetector _syntheticTerminalDetector;
  
  private <T extends Object> T reflectiveGet(final String fieldName) {
    try {
      return this.reflector.<T>get(this, fieldName);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        throw new RuntimeException(e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @Override
  protected boolean hasSyntheticTerminalRule() {
    final Function1<TerminalRule, Boolean> _function = (TerminalRule it) -> {
      return Boolean.valueOf(this._syntheticTerminalDetector.isSyntheticTerminalRule(it));
    };
    return IterableExtensions.<TerminalRule>exists(GrammarUtil.allTerminalRules(this.getGrammar()), _function);
  }
  
  private ContentAssistGrammarNaming getContentAssistNaming() {
    return this.<ContentAssistGrammarNaming>reflectiveGet("contentAssistNaming");
  }
  
  private FileAccessFactory getFileFactory() {
    return this.<FileAccessFactory>reflectiveGet("fileFactory");
  }
  
  private boolean isPartialParsing() {
    return (this.<Boolean>reflectiveGet("partialParsing")).booleanValue();
  }
  
  /**
   * This method was copied from the super class to extract the logic for {@link #initNameMappings()}
   * which needs access to the flattened grammar.
   */
  @Override
  public JavaFileAccess generateContentAssistParser() {
    GeneratedJavaFileAccess _xblockexpression = null;
    {
      @Extension
      final ContentAssistGrammarNaming naming = this.getContentAssistNaming();
      final GeneratedJavaFileAccess file = this.getFileFactory().createGeneratedJavaFile(naming.getParserClass(this.getGrammar()));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("public class ");
          String _simpleName = naming.getParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar()).getSimpleName();
          _builder.append(_simpleName);
          _builder.append(" extends ");
          TypeReference _parserSuperClass = naming.getParserSuperClass(N4JSAntlrGeneratorFragment2.this.getGrammar(), N4JSAntlrGeneratorFragment2.this.isPartialParsing());
          _builder.append(_parserSuperClass);
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@");
          _builder.append(Inject.class, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("private ");
          TypeReference _grammarAccess = N4JSAntlrGeneratorFragment2.this.grammarUtil.getGrammarAccess(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_grammarAccess, "\t");
          _builder.append(" grammarAccess;");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("private ");
          _builder.append(Map.class, "\t");
          _builder.append("<");
          _builder.append(AbstractElement.class, "\t");
          _builder.append(", String> nameMappings;");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected ");
          TypeReference _internalParserClass = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_internalParserClass, "\t");
          _builder.append(" createParser() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          TypeReference _internalParserClass_1 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_internalParserClass_1, "\t\t");
          _builder.append(" result = new ");
          TypeReference _internalParserClass_2 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_internalParserClass_2, "\t\t");
          _builder.append("(null);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("result.setGrammarAccess(grammarAccess);");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("return result;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          {
            boolean _hasSyntheticTerminalRule = N4JSAntlrGeneratorFragment2.this.hasSyntheticTerminalRule();
            if (_hasSyntheticTerminalRule) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("protected ");
              _builder.append(TokenSource.class, "\t");
              _builder.append(" createLexer(");
              _builder.append(CharStream.class, "\t");
              _builder.append(" stream) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return new ");
              TypeReference _tokenSourceClass = naming.getTokenSourceClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
              _builder.append(_tokenSourceClass, "\t\t");
              _builder.append("(super.createLexer(stream));");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected String getRuleName(");
          _builder.append(AbstractElement.class, "\t");
          _builder.append(" element) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("if (nameMappings == null) {");
          _builder.newLine();
          _builder.append("\t\t\t");
          StringConcatenationClient _initNameMappings = N4JSAntlrGeneratorFragment2.this.initNameMappings(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_initNameMappings, "\t\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("return nameMappings.get(element);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected ");
          _builder.append(Collection.class, "\t");
          _builder.append("<");
          TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement");
          _builder.append(_typeRef, "\t");
          _builder.append("> getFollowElements(");
          TypeReference _internalParserSuperClass = naming.getInternalParserSuperClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_internalParserSuperClass, "\t");
          _builder.append(" parser) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("try {");
          _builder.newLine();
          _builder.append("\t\t\t");
          TypeReference _internalParserClass_3 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_internalParserClass_3, "\t\t\t");
          _builder.append(" typedParser = (");
          TypeReference _internalParserClass_4 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_internalParserClass_4, "\t\t\t");
          _builder.append(") parser;");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("typedParser.");
          String _entryRuleName = N4JSAntlrGeneratorFragment2.this.grammarUtil.entryRuleName(AntlrGrammarGenUtil.<ParserRule>getOriginalElement(IterableExtensions.<ParserRule>head(GrammarUtil.allParserRules(N4JSAntlrGeneratorFragment2.this.getGrammar()))));
          _builder.append(_entryRuleName, "\t\t\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("return typedParser.getFollowElements();");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("} catch(");
          _builder.append(RecognitionException.class, "\t\t");
          _builder.append(" ex) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("throw new ");
          _builder.append(RuntimeException.class, "\t\t\t");
          _builder.append("(ex);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected String[] getInitialHiddenTokens() {");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("return new String[] { ");
          {
            List<String> _initialHiddenTokens = N4JSAntlrGeneratorFragment2.this.grammarUtil.initialHiddenTokens(N4JSAntlrGeneratorFragment2.this.getGrammar());
            boolean _hasElements = false;
            for(final String hidden : _initialHiddenTokens) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "\t\t");
              }
              _builder.append("\"");
              _builder.append(hidden, "\t\t");
              _builder.append("\"");
            }
          }
          _builder.append(" };");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          TypeReference _grammarAccess_1 = N4JSAntlrGeneratorFragment2.this.grammarUtil.getGrammarAccess(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_grammarAccess_1, "\t");
          _builder.append(" getGrammarAccess() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return this.grammarAccess;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public void setGrammarAccess(");
          TypeReference _grammarAccess_2 = N4JSAntlrGeneratorFragment2.this.grammarUtil.getGrammarAccess(N4JSAntlrGeneratorFragment2.this.getGrammar());
          _builder.append(_grammarAccess_2, "\t");
          _builder.append(" grammarAccess) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("this.grammarAccess = grammarAccess;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      file.setContent(_client);
      _xblockexpression = file;
    }
    return _xblockexpression;
  }
  
  /**
   * Produce the initial name mappings for the grammar. Handles parameterized rule calls.
   */
  private StringConcatenationClient initNameMappings(final Grammar it) {
    final RuleFilter filter = new RuleFilter();
    filter.setDiscardUnreachableRules(true);
    final RuleNames ruleNames = RuleNames.getRuleNames(it, true);
    final Grammar flattened = new FlattenedGrammarAccess(ruleNames, filter).getFlattenedGrammar();
    final Set<AbstractElement> seenElements = CollectionLiterals.<AbstractElement>newHashSet();
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(ImmutableMap.class);
        _builder.append(".Builder<");
        _builder.append(AbstractElement.class);
        _builder.append(", String> nameMappingsBuilder = ");
        _builder.append(ImmutableMap.class);
        _builder.append(".builder();");
        _builder.newLineIfNotEmpty();
        {
          Collection<? extends AbstractElement> _allAlternatives = GrammarUtil.getAllAlternatives(flattened);
          Collection<? extends AbstractElement> _allGroups = GrammarUtil.getAllGroups(flattened);
          Iterable<AbstractElement> _plus = Iterables.<AbstractElement>concat(_allAlternatives, _allGroups);
          Collection<? extends AbstractElement> _allAssignments = GrammarUtil.getAllAssignments(flattened);
          Iterable<AbstractElement> _plus_1 = Iterables.<AbstractElement>concat(_plus, _allAssignments);
          Collection<? extends AbstractElement> _allUnorderedGroups = GrammarUtil.getAllUnorderedGroups(flattened);
          final Function1<AbstractElement, Boolean> _function = (AbstractElement it_1) -> {
            return Boolean.valueOf(seenElements.add(AntlrGrammarGenUtil.<AbstractElement>getOriginalElement(it_1)));
          };
          Iterable<AbstractElement> _filter = IterableExtensions.<AbstractElement>filter(Iterables.<AbstractElement>filter(Iterables.<AbstractElement>concat(_plus_1, _allUnorderedGroups), AbstractElement.class), _function);
          for(final AbstractElement element : _filter) {
            _builder.append("nameMappingsBuilder.put(grammarAccess.");
            String _grammarElementAccess = N4JSAntlrGeneratorFragment2.this.grammarUtil.grammarElementAccess(AntlrGrammarGenUtil.<AbstractElement>getOriginalElement(element));
            _builder.append(_grammarElementAccess);
            _builder.append(", \"");
            String _contentAssistRuleName = AntlrGrammarGenUtil.getContentAssistRuleName(GrammarUtil.containingRule(AntlrGrammarGenUtil.<AbstractElement>getOriginalElement(element)));
            _builder.append(_contentAssistRuleName);
            _builder.append("__");
            String _gaElementIdentifier = N4JSAntlrGeneratorFragment2.this.grammarUtil.gaElementIdentifier(AntlrGrammarGenUtil.<AbstractElement>getOriginalElement(element));
            _builder.append(_gaElementIdentifier);
            {
              if ((element instanceof Group)) {
                _builder.append("__0");
              }
            }
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("nameMappings = nameMappingsBuilder.build();");
        _builder.newLine();
      }
    };
    return _client;
  }
  
  private final static Logger LOG = Logger.getLogger(N4JSAntlrGeneratorFragment2.class);
}
