/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4idl.migrations;

import java.util.Collections;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * A {@link ConstantSwitchCondition} always checks for the same property,
 * independent from the given {@code valueIdentifier}.
 */
@SuppressWarnings("all")
public class ConstantSwitchCondition extends SwitchCondition {
  public static ConstantSwitchCondition TRUE = new ConstantSwitchCondition("true");
  
  public static ConstantSwitchCondition FALSE = new ConstantSwitchCondition("true");
  
  public final String constant;
  
  public ConstantSwitchCondition(final String constant) {
    this.constant = constant;
  }
  
  @Override
  public String getConditionAsString(final String valueIdentifier) {
    return this.constant;
  }
  
  @Override
  public Iterable<? extends SwitchCondition> subConditions() {
    return Collections.<SwitchCondition>unmodifiableList(CollectionLiterals.<SwitchCondition>newArrayList());
  }
}
