/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSClassifierDeclarationTypesBuilder;
import org.eclipse.n4js.typesbuilder.VersionedTypesBuilderUtil;
import org.eclipse.n4js.utils.N4JSLanguageUtils;

@SuppressWarnings("all")
public class N4JSClassDeclarationTypesBuilder extends N4JSClassifierDeclarationTypesBuilder {
  protected boolean relinkTClass(final N4ClassDeclaration n4Class, final TModule target, final boolean preLinkingPhase, final int idx) {
    String _name = n4Class.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return false;
    }
    Type _get = target.getTopLevelTypes().get(idx);
    final TClass tclass = ((TClass) _get);
    this.relinkClassifierAndMembers(tclass, n4Class, preLinkingPhase);
    return true;
  }
  
  protected TClass createTClass(final N4ClassDeclaration n4Class, final TModule target, final boolean preLinkingPhase) {
    String _name = n4Class.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return null;
    }
    final TClass tclass = this.createTClass(n4Class);
    this._n4JSTypesBuilderHelper.<N4ClassDeclaration>setTypeAccessModifier(tclass, n4Class);
    this._n4JSTypesBuilderHelper.setProvidedByRuntime(tclass, n4Class, preLinkingPhase);
    tclass.setDeclaredStaticPolyfill(N4JSLanguageUtils.isStaticPolyfill(n4Class));
    tclass.setDeclaredPolyfill((N4JSLanguageUtils.isPolyfill(n4Class) || tclass.isDeclaredStaticPolyfill()));
    tclass.setDeclaredCovariantConstructor(this._n4JSTypesBuilderHelper.isDeclaredCovariantConstructor(n4Class));
    this.addTypeParameters(tclass, n4Class, preLinkingPhase);
    this.setSuperType(tclass, n4Class, preLinkingPhase);
    this.addImplementedInterfaces(tclass, n4Class, preLinkingPhase);
    this.addFields(tclass, n4Class, preLinkingPhase);
    this.addMethods(tclass, n4Class, preLinkingPhase);
    this.addGetters(tclass, n4Class, preLinkingPhase);
    this.addSetters(tclass, n4Class, preLinkingPhase);
    this._n4JSTypesBuilderHelper.copyAnnotations(tclass, n4Class, preLinkingPhase);
    tclass.setAstElement(n4Class);
    n4Class.setDefinedType(tclass);
    EList<Type> _topLevelTypes = target.getTopLevelTypes();
    _topLevelTypes.add(tclass);
    return tclass;
  }
  
  boolean createTClass(final N4ClassExpression n4Class, final TModule target, final boolean preLinkingPhase) {
    boolean _xblockexpression = false;
    {
      final TClass tclass = this.createTClass(n4Class);
      this.setSuperType(tclass, n4Class, preLinkingPhase);
      this.addImplementedInterfaces(tclass, n4Class, preLinkingPhase);
      this.addFields(tclass, n4Class, preLinkingPhase);
      this.addMethods(tclass, n4Class, preLinkingPhase);
      this.addGetters(tclass, n4Class, preLinkingPhase);
      this.addSetters(tclass, n4Class, preLinkingPhase);
      this._n4JSTypesBuilderHelper.copyAnnotations(tclass, n4Class, preLinkingPhase);
      tclass.setAstElement(n4Class);
      n4Class.setDefinedType(tclass);
      EList<Type> _internalTypes = target.getInternalTypes();
      _xblockexpression = _internalTypes.add(tclass);
    }
    return _xblockexpression;
  }
  
  private TClass createTClass(final N4ClassDeclaration classDecl) {
    final TClass tclass = TypesFactory.eINSTANCE.createTClass();
    tclass.setName(classDecl.getName());
    tclass.setExportedName(classDecl.getExportedName());
    tclass.setExternal(classDecl.isExternal());
    tclass.setDeclaredAbstract(classDecl.isAbstract());
    tclass.setDeclaredFinal(AnnotationDefinition.FINAL.hasAnnotation(classDecl));
    tclass.setObservable(AnnotationDefinition.OBSERVABLE.hasAnnotation(classDecl));
    tclass.setDeclaredN4JS(AnnotationDefinition.N4JS.hasAnnotation(classDecl));
    TypingStrategy _xifexpression = null;
    TypingStrategy _typingStrategy = classDecl.getTypingStrategy();
    boolean _tripleEquals = (_typingStrategy == TypingStrategy.DEFAULT);
    if (_tripleEquals) {
      _xifexpression = TypingStrategy.DEFAULT;
    } else {
      _xifexpression = TypingStrategy.STRUCTURAL;
    }
    tclass.setTypingStrategy(_xifexpression);
    VersionedTypesBuilderUtil.setTypeVersion(tclass, classDecl);
    return tclass;
  }
  
  private TClass createTClass(final N4ClassExpression classExpr) {
    final TClass tclass = TypesFactory.eINSTANCE.createTClass();
    tclass.setName(classExpr.getName());
    return tclass;
  }
  
  private void setSuperType(final TClass tclass, final N4ClassDefinition classDecl, final boolean preLinkingPhase) {
    if ((!preLinkingPhase)) {
      tclass.setSuperClassRef(TypeUtils.<ParameterizedTypeRef>copyWithProxies(classDecl.getSuperClassRef()));
    }
  }
  
  private void addImplementedInterfaces(final TClass tclass, final N4ClassDefinition classDecl, final boolean preLinkingPhase) {
    if ((!preLinkingPhase)) {
      this._n4JSTypesBuilderHelper.<ParameterizedTypeRef>addCopyOfReferences(tclass.getImplementedInterfaceRefs(), classDecl.getImplementedInterfaceRefs());
    }
  }
}
