/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import com.google.inject.Inject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.typesbuilder.N4JSFormalParameterTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
class N4JSSetterTypesBuilder {
  @Inject
  @Extension
  private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
  
  @Inject
  @Extension
  private N4JSFormalParameterTypesBuilder _n4JSFormalParameterTypesBuilder;
  
  boolean relinkSetter(final N4SetterDeclaration n4Setter, final TClassifier classifierType, final boolean preLinkingPhase, final int idx) {
    if (((n4Setter.getName() == null) && (!n4Setter.hasComputedPropertyName()))) {
      return false;
    }
    TMember _get = classifierType.getOwnedMembers().get(idx);
    final TSetter setterType = ((TSetter) _get);
    this._n4JSTypesBuilderHelper.ensureEqualName(n4Setter, setterType);
    this.linkFormalParameters(setterType, n4Setter, preLinkingPhase);
    setterType.setAstElement(n4Setter);
    n4Setter.setDefinedSetter(setterType);
    return true;
  }
  
  TSetter createSetter(final N4SetterDeclaration n4Setter, final TClassifier classifierType, final boolean preLinkingPhase) {
    TSetter _xblockexpression = null;
    {
      if (((n4Setter.getName() == null) && (!n4Setter.hasComputedPropertyName()))) {
        return null;
      }
      final BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get(n4Setter.eResource().getResourceSet());
      final TSetter setterType = TypesFactory.eINSTANCE.createTSetter();
      this._n4JSTypesBuilderHelper.setMemberName(setterType, n4Setter);
      setterType.setDeclaredAbstract(n4Setter.isAbstract());
      setterType.setDeclaredStatic(n4Setter.isDeclaredStatic());
      setterType.setDeclaredFinal(n4Setter.isDeclaredFinal());
      setterType.setOptional(n4Setter.isOptional());
      setterType.setDeclaredOverride(AnnotationDefinition.OVERRIDE.hasAnnotation(n4Setter));
      setterType.setHasNoBody(((n4Setter.getBody() == null) && (!AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.hasAnnotation(n4Setter))));
      this.setMemberAccessModifier(setterType, n4Setter);
      this.addFormalParameters(setterType, n4Setter, builtInTypeScope, preLinkingPhase);
      this._n4JSTypesBuilderHelper.setDeclaredThisTypeFromAnnotation(setterType, n4Setter, preLinkingPhase);
      this._n4JSTypesBuilderHelper.copyAnnotations(setterType, n4Setter, preLinkingPhase);
      setterType.setAstElement(n4Setter);
      n4Setter.setDefinedSetter(setterType);
      _xblockexpression = setterType;
    }
    return _xblockexpression;
  }
  
  private void setMemberAccessModifier(final TSetter setterType, final N4SetterDeclaration n4Setter) {
    final Procedure1<MemberAccessModifier> _function = (MemberAccessModifier modifier) -> {
      setterType.setDeclaredMemberAccessModifier(modifier);
    };
    this._n4JSTypesBuilderHelper.setMemberAccessModifier(_function, 
      n4Setter.getDeclaredModifiers(), n4Setter.getAnnotations());
  }
  
  private void addFormalParameters(final TSetter setterType, final N4SetterDeclaration n4Setter, final BuiltInTypeScope builtInTypeScope, final boolean preLinkingPhase) {
    FormalParameter _fpar = n4Setter.getFpar();
    boolean _tripleNotEquals = (_fpar != null);
    if (_tripleNotEquals) {
      setterType.setFpar(this._n4JSFormalParameterTypesBuilder.createFormalParameter(n4Setter.getFpar(), builtInTypeScope, preLinkingPhase));
    }
  }
  
  private boolean linkFormalParameters(final TSetter setterType, final N4SetterDeclaration n4Setter, final boolean preLinkingPhase) {
    FormalParameter _fpar = n4Setter.getFpar();
    boolean _tripleEquals = (_fpar == null);
    if (_tripleEquals) {
      return false;
    }
    final TFormalParameter formalParameterType = setterType.getFpar();
    this._n4JSTypesBuilderHelper.ensureEqualName(n4Setter.getFpar(), formalParameterType);
    formalParameterType.setAstElement(n4Setter.getFpar());
    FormalParameter _fpar_1 = n4Setter.getFpar();
    _fpar_1.setDefinedTypeElement(formalParameterType);
    return true;
  }
}
