/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.parser;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.tests.parser.AbstractParserTest;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

public abstract class AbstractStructuralTypingTest
extends AbstractParserTest {
    public void assertField(String expectedType, String expectedName, TMember member) {
        TField field = this.assertType(TField.class, member);
        TypeRef _typeRef = field.getTypeRef();
        String _typeRefAsString = null;
        if (_typeRef != null) {
            _typeRefAsString = _typeRef.getTypeRefAsString();
        }
        Assert.assertEquals((Object)expectedType, (Object)_typeRefAsString);
        Assert.assertEquals((Object)expectedName, (Object)field.getName());
    }

    public void assertMethod(String expectedType, List<String> expectedFPars, String expectedName, TMember member) {
        TMethod method = this.assertType(TMethod.class, member);
        TypeRef _returnTypeRef = method.getReturnTypeRef();
        String _typeRefAsString = null;
        if (_returnTypeRef != null) {
            _typeRefAsString = _returnTypeRef.getTypeRefAsString();
        }
        Assert.assertEquals((Object)expectedType, (Object)_typeRefAsString);
        Assert.assertEquals((Object)expectedName, (Object)method.getName());
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String p : expectedFPars) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append(p);
        }
        String expected = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        EList _fpars = method.getFpars();
        boolean _hasElements_1 = false;
        for (TFormalParameter m : _fpars) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder_1.appendImmediate((Object)",", "");
            }
            String _typeRefAsString_1 = m.getTypeRef().getTypeRefAsString();
            _builder_1.append(_typeRefAsString_1);
        }
        String actual = _builder_1.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertGetter(String expectedType, String expectedName, TMember member) {
        TGetter getter = this.assertType(TGetter.class, member);
        TypeRef _declaredTypeRef = getter.getDeclaredTypeRef();
        String _typeRefAsString = null;
        if (_declaredTypeRef != null) {
            _typeRefAsString = _declaredTypeRef.getTypeRefAsString();
        }
        Assert.assertEquals((Object)expectedType, (Object)_typeRefAsString);
        Assert.assertEquals((Object)expectedName, (Object)getter.getName());
    }

    public void assertSetter(String expectedType, String expectedName, TMember member) {
        TSetter setter = this.assertType(TSetter.class, member);
        TypeRef _declaredTypeRef = setter.getDeclaredTypeRef();
        String _typeRefAsString = null;
        if (_declaredTypeRef != null) {
            _typeRefAsString = _declaredTypeRef.getTypeRefAsString();
        }
        Assert.assertEquals((Object)expectedType, (Object)_typeRefAsString);
        Assert.assertEquals((Object)expectedName, (Object)setter.getName());
    }

    public void assertAdditionalFieldsPTR(TypingStrategy expectedStrategy, List<Pair<String, String>> pairs, TypeRef ref) {
        this.assertType(ParameterizedTypeRefStructural.class, ref);
        ParameterizedTypeRefStructural ptrs = (ParameterizedTypeRefStructural)ref;
        String _name = expectedStrategy.getName();
        String _plus = "Expected " + _name;
        String _plus_1 = String.valueOf(_plus) + " but was ";
        TypingStrategy _typingStrategy = ptrs.getTypingStrategy();
        String _name_1 = null;
        if (_typingStrategy != null) {
            _name_1 = _typingStrategy.getName();
        }
        String _plus_2 = String.valueOf(_plus_1) + _name_1;
        String _plus_3 = String.valueOf(_plus_2) + ": ";
        Assert.assertEquals((String)_plus_3, (Object)expectedStrategy, (Object)ptrs.getTypingStrategy());
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Pair<String, String> p : pairs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _value = (String)p.getValue();
            _builder.append(_value);
            _builder.append(" ");
            String _key = (String)p.getKey();
            _builder.append(_key);
        }
        String expected = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)ptrs.getStructuralMembers(), TField.class);
        boolean _hasElements_1 = false;
        for (TField m : _filter) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder_1.appendImmediate((Object)",", "");
            }
            TypeRef _typeRef = m.getTypeRef();
            String _typeRefAsString = null;
            if (_typeRef != null) {
                _typeRefAsString = _typeRef.getTypeRefAsString();
            }
            _builder_1.append(_typeRefAsString);
            _builder_1.append(" ");
            String _name_2 = m.getName();
            _builder_1.append(_name_2);
        }
        String actual = _builder_1.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertAdditionalFieldsThis(TypingStrategy expectedStrategy, List<Pair<String, String>> pairs, TypeRef ref) {
        this.assertType(ThisTypeRefStructural.class, ref);
        ThisTypeRefStructural ptrs = (ThisTypeRefStructural)ref;
        String _name = expectedStrategy.getName();
        String _plus = "Expected " + _name;
        String _plus_1 = String.valueOf(_plus) + " but was ";
        TypingStrategy _typingStrategy = ptrs.getTypingStrategy();
        String _name_1 = null;
        if (_typingStrategy != null) {
            _name_1 = _typingStrategy.getName();
        }
        String _plus_2 = String.valueOf(_plus_1) + _name_1;
        String _plus_3 = String.valueOf(_plus_2) + ": ";
        Assert.assertEquals((String)_plus_3, (Object)expectedStrategy, (Object)ptrs.getTypingStrategy());
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Pair<String, String> p : pairs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _value = (String)p.getValue();
            _builder.append(_value);
            _builder.append(" ");
            String _key = (String)p.getKey();
            _builder.append(_key);
        }
        String expected = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)ptrs.getStructuralMembers(), TField.class);
        boolean _hasElements_1 = false;
        for (TField m : _filter) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder_1.appendImmediate((Object)",", "");
            }
            TypeRef _typeRef = m.getTypeRef();
            String _typeRefAsString = null;
            if (_typeRef != null) {
                _typeRefAsString = _typeRef.getTypeRefAsString();
            }
            _builder_1.append(_typeRefAsString);
            _builder_1.append(" ");
            String _name_2 = m.getName();
            _builder_1.append(_name_2);
        }
        String actual = _builder_1.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public <T> T assertType(Class<T> type, Object obj) {
        String _simpleName = type.getSimpleName();
        String _plus = "Expected type " + _simpleName;
        String _plus_1 = String.valueOf(_plus) + " but got ";
        String _simpleName_1 = obj.getClass().getSimpleName();
        String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
        Assert.assertTrue((String)_plus_2, (boolean)type.isInstance(obj));
        return (T)obj;
    }
}

