/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.n4idl.assistants;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4idl.N4IDLGlobals;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedTypeRef_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TypeDefs;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Transformation assistant for transforming N4IDL class and interface declarations.
 */
@SuppressWarnings("all")
public class N4IDLClassifierTransformationAssistant extends TransformationAssistant {
  /**
   * Creates the static initializer statement for the given {@code classifierSTE} which
   * initializes the {@link N4IDLGlobals#N4_SUPER_INTERFACE_STATIC_FIELD} field based on
   * the given {@param classifierDeclaration}.
   * 
   * This allows runtime access to the directly implemented interfaces of an N4IDL class or interface.
   */
  public Statement createImplementedInterfaceStaticInitializer(final SymbolTableEntry classifierSTE, final N4ClassifierDeclaration classifierDeclaration) {
    final Function1<ParameterizedTypeRef, SymbolTableEntry> _function = (ParameterizedTypeRef ref) -> {
      return ((ParameterizedTypeRef_IM) ref).getRewiredTarget();
    };
    final Function1<SymbolTableEntry, ArrayElement> _function_1 = (SymbolTableEntry t) -> {
      return TranspilerBuilderBlocks._ArrayElement(TranspilerBuilderBlocks._IdentRef(t));
    };
    final Expression superInterfaceFieldValue = TranspilerBuilderBlocks._ArrLit(
      ((ArrayElement[])Conversions.unwrapArray(IterableExtensions.<SymbolTableEntry, ArrayElement>map(IterableExtensions.<ParameterizedTypeRef, SymbolTableEntry>map(this.getNonStructuralSuperClassifiers(classifierDeclaration), _function), _function_1), ArrayElement.class)));
    final ParameterizedPropertyAccessExpression_IM staticFieldAccess = TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._IdentRef(classifierSTE), this.getSymbolTableEntryInternal(N4IDLGlobals.N4_SUPER_INTERFACE_STATIC_FIELD, true));
    return TranspilerBuilderBlocks._ExprStmnt(TranspilerBuilderBlocks._AssignmentExpr(staticFieldAccess, superInterfaceFieldValue));
  }
  
  /**
   * Returns an iterable of super classifiers (only TN4Classifiers) that are not declared to
   * be def-site structural (.typeingStrategy == NOMINAL).
   */
  private Iterable<ParameterizedTypeRef> getNonStructuralSuperClassifiers(final N4ClassifierDeclaration declaration) {
    final Function1<ParameterizedTypeRef, Boolean> _function = (ParameterizedTypeRef ref) -> {
      return Boolean.valueOf(this.includeInImplementedInterfaces(((ParameterizedTypeRef_IM) ref)));
    };
    return IterableExtensions.<ParameterizedTypeRef>filter(declaration.getImplementedOrExtendedInterfaceRefs(), _function);
  }
  
  private boolean includeInImplementedInterfaces(final ParameterizedTypeRef_IM interfaceRef) {
    final SymbolTableEntry interfaceSTE = interfaceRef.getRewiredTarget();
    if ((interfaceSTE instanceof SymbolTableEntryOriginal)) {
      IdentifiableElement _originalTarget = ((SymbolTableEntryOriginal)interfaceSTE).getOriginalTarget();
      final TInterface declaredType = ((TInterface) _originalTarget);
      if (((declaredType.getTypingStrategy() != TypingStrategy.DEFAULT) && 
        (declaredType.getTypingStrategy() != TypingStrategy.NOMINAL))) {
        return false;
      }
      EObject _eContainer = declaredType.eContainer();
      if ((_eContainer instanceof TypeDefs)) {
        return false;
      }
      return true;
    }
    return false;
  }
}
