/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.BootstrapCallAssistant;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class InterfaceDeclarationTransformation extends Transformation {
  @Inject
  private BootstrapCallAssistant bootstrapCallAssistant;
  
  @Inject
  private TypeAssistant typeAssistant;
  
  @Override
  public void assertPreConditions() {
    this.typeAssistant.assertClassifierPreConditions();
  }
  
  @Override
  public void assertPostConditions() {
  }
  
  @Override
  public void analyze() {
  }
  
  @Override
  public void transform() {
    final Consumer<N4InterfaceDeclaration> _function = (N4InterfaceDeclaration it) -> {
      this.transformInterfaceDecl(it);
    };
    this.<N4InterfaceDeclaration>collectNodes(this.getState().im, N4InterfaceDeclaration.class, false).forEach(_function);
  }
  
  private void transformInterfaceDecl(final N4InterfaceDeclaration ifcDecl) {
    final SymbolTableEntry ifcSTE = this.findSymbolTableEntryForElement(ifcDecl, true);
    final VariableDeclaration varDecl = this.createVarDecl(ifcDecl);
    final ExpressionStatement fieldInitFun = this.createInstanceFieldInitializationFunction(ifcDecl, ifcSTE);
    final List<Statement> staticFieldInits = this.createStaticFieldInitializations(ifcSTE, ifcDecl);
    final Statement[] memberDefs = this.bootstrapCallAssistant.createInterfaceMemberDefinitionSection(ifcDecl);
    final ExpressionStatement makeIfcCall = this.bootstrapCallAssistant.createMakeInterfaceCall(ifcDecl);
    this.getState().tracer.copyTrace(ifcDecl, ((EObject[])Conversions.unwrapArray(staticFieldInits, EObject.class)));
    this.getState().tracer.copyTrace(ifcDecl, memberDefs);
    this.getState().tracer.copyTrace(ifcDecl, makeIfcCall);
    this.replace(ifcDecl, varDecl);
    final EObject root = TranspilerUtils.orContainingExportDeclaration(varDecl.eContainer());
    Iterable<Statement> _plus = Iterables.<Statement>concat(Collections.<ExpressionStatement>unmodifiableList(CollectionLiterals.<ExpressionStatement>newArrayList(fieldInitFun)), staticFieldInits);
    Iterable<Statement> _plus_1 = Iterables.<Statement>concat(_plus, ((Iterable<? extends Statement>)Conversions.doWrapArray(memberDefs)));
    Iterable<Statement> _plus_2 = Iterables.<Statement>concat(_plus_1, Collections.<ExpressionStatement>unmodifiableList(CollectionLiterals.<ExpressionStatement>newArrayList(makeIfcCall)));
    this.insertAfter(root, ((EObject[])Conversions.unwrapArray(_plus_2, EObject.class)));
    this.getState().info.markAsToHoist(varDecl);
  }
  
  /**
   * Creates declaration of the variable that will represent the interface.
   */
  private VariableDeclaration createVarDecl(final N4InterfaceDeclaration ifcDecl) {
    VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration(ifcDecl.getName());
    final Procedure1<VariableDeclaration> _function = (VariableDeclaration it) -> {
      it.setExpression(TranspilerBuilderBlocks._ObjLit());
    };
    return ObjectExtensions.<VariableDeclaration>operator_doubleArrow(__VariableDeclaration, _function);
  }
  
  private ExpressionStatement createInstanceFieldInitializationFunction(final N4InterfaceDeclaration ifcDecl, final SymbolTableEntry ifcSTE) {
    final SymbolTableEntryInternal $fieldInitSTE = this.steFor_$fieldInit();
    AssignmentExpression __AssignmentExpr = TranspilerBuilderBlocks._AssignmentExpr();
    final Procedure1<AssignmentExpression> _function = (AssignmentExpression it) -> {
      it.setLhs(TranspilerBuilderBlocks._PropertyAccessExpr(ifcSTE, $fieldInitSTE));
      String _name = ifcDecl.getName();
      String _plus = (_name + "_fieldInit");
      FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar("spec");
      FormalParameter __Fpar_1 = TranspilerBuilderBlocks._Fpar("mixinExclusion");
      FunctionExpression __FunExpr = TranspilerBuilderBlocks._FunExpr(false, _plus, new FormalParameter[] { __Fpar, __Fpar_1 });
      final Procedure1<FunctionExpression> _function_1 = (FunctionExpression it_1) -> {
        EList<Statement> _statements = it_1.getBody().getStatements();
        Statement[] _createInstanceFieldInitializations = this.createInstanceFieldInitializations(ifcDecl);
        Iterables.<Statement>addAll(_statements, ((Iterable<? extends Statement>)Conversions.doWrapArray(_createInstanceFieldInitializations)));
        EList<Statement> _statements_1 = it_1.getBody().getStatements();
        Statement[] _createDelegationToFieldInitOfExtendedInterfaces = this.createDelegationToFieldInitOfExtendedInterfaces(ifcDecl);
        Iterables.<Statement>addAll(_statements_1, ((Iterable<? extends Statement>)Conversions.doWrapArray(_createDelegationToFieldInitOfExtendedInterfaces)));
      };
      FunctionExpression _doubleArrow = ObjectExtensions.<FunctionExpression>operator_doubleArrow(__FunExpr, _function_1);
      it.setRhs(_doubleArrow);
    };
    AssignmentExpression _doubleArrow = ObjectExtensions.<AssignmentExpression>operator_doubleArrow(__AssignmentExpr, _function);
    return TranspilerBuilderBlocks._ExprStmnt(_doubleArrow);
  }
  
  private Statement[] createInstanceFieldInitializations(final N4InterfaceDeclaration ifcDecl) {
    final Function1<N4FieldDeclaration, Boolean> _function = (N4FieldDeclaration it) -> {
      boolean _isStatic = it.isStatic();
      return Boolean.valueOf((!_isStatic));
    };
    final List<N4FieldDeclaration> fields = IterableExtensions.<N4FieldDeclaration>toList(IterableExtensions.<N4FieldDeclaration>filter(ifcDecl.getOwnedFields(), _function));
    boolean _isEmpty = fields.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final SymbolTableEntryOriginal hasOwnPropertySTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType(this.getState().G), "hasOwnProperty", false, false, true);
      final ArrayList<Statement> fieldInitsFromSpec = CollectionLiterals.<Statement>newArrayList();
      final ArrayList<Statement> fieldInitsNormal = CollectionLiterals.<Statement>newArrayList();
      for (final N4FieldDeclaration field : fields) {
        {
          final SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement(field, true);
          Expression _xifexpression = null;
          Expression _expression = field.getExpression();
          boolean _tripleNotEquals = (_expression != null);
          if (_tripleNotEquals) {
            _xifexpression = this.<Expression>copy(field.getExpression());
          } else {
            _xifexpression = this.undefinedRef();
          }
          final ExpressionStatement specStmnt = TranspilerBuilderBlocks._ExprStmnt(
            TranspilerBuilderBlocks._AssignmentExpr(
              TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._Snippet("this"), fieldSTE), 
              TranspilerBuilderBlocks._ConditionalExpr(
                TranspilerBuilderBlocks._RelationalExpr(TranspilerBuilderBlocks._StringLiteralForSTE(fieldSTE), RelationalOperator.IN, TranspilerBuilderBlocks._Snippet("spec")), 
                TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._Snippet("spec"), fieldSTE), _xifexpression)));
          IfStatement _ifStmntMixinExclusionORtarget = this.ifStmntMixinExclusionORtarget(hasOwnPropertySTE, fieldSTE, specStmnt);
          fieldInitsFromSpec.add(_ifStmntMixinExclusionORtarget);
          Expression _xifexpression_1 = null;
          Expression _expression_1 = field.getExpression();
          boolean _tripleNotEquals_1 = (_expression_1 != null);
          if (_tripleNotEquals_1) {
            _xifexpression_1 = this.<Expression>copy(field.getExpression());
          } else {
            _xifexpression_1 = this.undefinedRef();
          }
          final ExpressionStatement trueBody = TranspilerBuilderBlocks._ExprStmnt(
            TranspilerBuilderBlocks._AssignmentExpr(
              TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._Snippet("this"), fieldSTE), _xifexpression_1));
          IfStatement _ifStmntMixinExclusionORtarget_1 = this.ifStmntMixinExclusionORtarget(hasOwnPropertySTE, fieldSTE, trueBody);
          fieldInitsNormal.add(_ifStmntMixinExclusionORtarget_1);
        }
      }
      IfStatement __IfStmnt = TranspilerBuilderBlocks._IfStmnt(
        TranspilerBuilderBlocks._Snippet("spec"), 
        TranspilerBuilderBlocks._Block(((Statement[])Conversions.unwrapArray(fieldInitsFromSpec, Statement.class))), 
        TranspilerBuilderBlocks._Block(((Statement[])Conversions.unwrapArray(fieldInitsNormal, Statement.class))));
      return new Statement[] { __IfStmnt };
    }
    return new Statement[] {};
  }
  
  private IfStatement ifStmntMixinExclusionORtarget(final SymbolTableEntry hasOwnPropertySTE, final SymbolTableEntry fieldSTE, final Statement trueBody) {
    return TranspilerBuilderBlocks._IfStmnt(
      TranspilerBuilderBlocks._NOT(
        TranspilerBuilderBlocks._Parenthesis(
          TranspilerBuilderBlocks._OR(
            TranspilerBuilderBlocks._CallExpr(TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._Snippet("mixinExclusion"), hasOwnPropertySTE), TranspilerBuilderBlocks._StringLiteralForSTE(fieldSTE)), 
            TranspilerBuilderBlocks._CallExpr(TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._Snippet("this"), hasOwnPropertySTE), TranspilerBuilderBlocks._StringLiteralForSTE(fieldSTE))))), trueBody);
  }
  
  private Statement[] createDelegationToFieldInitOfExtendedInterfaces(final N4InterfaceDeclaration ifcDecl) {
    final ArrayList<ExpressionStatement> result = CollectionLiterals.<ExpressionStatement>newArrayList();
    final SymbolTableEntryInternal $fieldInitSTE = this.steFor_$fieldInit();
    final Function1<SymbolTableEntryOriginal, Boolean> _function = (SymbolTableEntryOriginal it) -> {
      IdentifiableElement _originalTarget = it.getOriginalTarget();
      boolean _builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation = N4JSLanguageUtils.builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation(((TInterface) _originalTarget));
      return Boolean.valueOf((!_builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation));
    };
    final Iterable<SymbolTableEntryOriginal> superIfcSTEs = IterableExtensions.<SymbolTableEntryOriginal>filter(this.typeAssistant.getSuperInterfacesSTEs(ifcDecl), _function);
    for (final SymbolTableEntryOriginal superIfcSTE : superIfcSTEs) {
      ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt(
        TranspilerBuilderBlocks._CallExpr(
          this.__NSSafe_PropertyAccessExpr(superIfcSTE, $fieldInitSTE, this.steFor_call()), 
          TranspilerBuilderBlocks._Snippet("this"), TranspilerBuilderBlocks._Snippet("spec"), TranspilerBuilderBlocks._Snippet("mixinExclusion")));
      result.add(__ExprStmnt);
    }
    return ((Statement[])Conversions.unwrapArray(result, Statement.class));
  }
  
  /**
   * Creates a new list of statements to initialize the static fields of the given {@code ifcDecl}.
   * 
   * Clients of this method may modify the returned list.
   */
  protected List<Statement> createStaticFieldInitializations(final SymbolTableEntry ifcSTE, final N4InterfaceDeclaration ifcDecl) {
    final Function1<N4FieldDeclaration, Boolean> _function = (N4FieldDeclaration it) -> {
      return Boolean.valueOf(it.isStatic());
    };
    final Function1<N4FieldDeclaration, Boolean> _function_1 = (N4FieldDeclaration it) -> {
      Expression _expression = it.getExpression();
      return Boolean.valueOf((_expression != null));
    };
    final Function1<N4FieldDeclaration, Statement> _function_2 = (N4FieldDeclaration fieldDecl) -> {
      AssignmentExpression __AssignmentExpr = TranspilerBuilderBlocks._AssignmentExpr();
      final Procedure1<AssignmentExpression> _function_3 = (AssignmentExpression it) -> {
        it.setLhs(TranspilerBuilderBlocks._PropertyAccessExpr(ifcSTE, this.findSymbolTableEntryForElement(fieldDecl, true)));
        it.setRhs(fieldDecl.getExpression());
      };
      AssignmentExpression _doubleArrow = ObjectExtensions.<AssignmentExpression>operator_doubleArrow(__AssignmentExpr, _function_3);
      return TranspilerBuilderBlocks._ExprStmnt(_doubleArrow);
    };
    return IterableExtensions.<Statement>toList(IterableExtensions.<N4FieldDeclaration, Statement>map(IterableExtensions.<N4FieldDeclaration>filter(IterableExtensions.<N4FieldDeclaration>filter(Iterables.<N4FieldDeclaration>filter(ifcDecl.getOwnedMembers(), N4FieldDeclaration.class), _function), _function_1), _function_2));
  }
}
