/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform.internal;

import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Immutable ValueObject for transforming imports.
 */
@Data
@SuppressWarnings("all")
public abstract class ImportAssignment {
  /**
   * Symbol table entry for the imported element.
   */
  private final SymbolTableEntryOriginal ste;
  
  public abstract ImportSpecifier getToBeReplacedImportSpecifier();
  
  public ImportAssignment(final SymbolTableEntryOriginal ste) {
    super();
    this.ste = ste;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.ste== null) ? 0 : this.ste.hashCode());
    return result;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ImportAssignment other = (ImportAssignment) obj;
    if (this.ste == null) {
      if (other.ste != null)
        return false;
    } else if (!this.ste.equals(other.ste))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("ste", this.ste);
    return b.toString();
  }
  
  @Pure
  public SymbolTableEntryOriginal getSte() {
    return this.ste;
  }
}
