/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform.internal;

import java.util.List;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.transpiler.es.transform.internal.ImportAssignment;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Immutable ValueObject for import-rewriting.
 */
@Data
@SuppressWarnings("all")
public class ImportEntry {
  private final String actualModuleSpecifier;
  
  private final List<ImportAssignment> variableSTE_actualName;
  
  private final ImportDeclaration toBeReplacedImportDeclaration;
  
  public ImportEntry(final String actualModuleSpecifier, final List<ImportAssignment> variableSTE_actualName, final ImportDeclaration toBeReplacedImportDeclaration) {
    super();
    this.actualModuleSpecifier = actualModuleSpecifier;
    this.variableSTE_actualName = variableSTE_actualName;
    this.toBeReplacedImportDeclaration = toBeReplacedImportDeclaration;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.actualModuleSpecifier== null) ? 0 : this.actualModuleSpecifier.hashCode());
    result = prime * result + ((this.variableSTE_actualName== null) ? 0 : this.variableSTE_actualName.hashCode());
    result = prime * result + ((this.toBeReplacedImportDeclaration== null) ? 0 : this.toBeReplacedImportDeclaration.hashCode());
    return result;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ImportEntry other = (ImportEntry) obj;
    if (this.actualModuleSpecifier == null) {
      if (other.actualModuleSpecifier != null)
        return false;
    } else if (!this.actualModuleSpecifier.equals(other.actualModuleSpecifier))
      return false;
    if (this.variableSTE_actualName == null) {
      if (other.variableSTE_actualName != null)
        return false;
    } else if (!this.variableSTE_actualName.equals(other.variableSTE_actualName))
      return false;
    if (this.toBeReplacedImportDeclaration == null) {
      if (other.toBeReplacedImportDeclaration != null)
        return false;
    } else if (!this.toBeReplacedImportDeclaration.equals(other.toBeReplacedImportDeclaration))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("actualModuleSpecifier", this.actualModuleSpecifier);
    b.add("variableSTE_actualName", this.variableSTE_actualName);
    b.add("toBeReplacedImportDeclaration", this.toBeReplacedImportDeclaration);
    return b.toString();
  }
  
  @Pure
  public String getActualModuleSpecifier() {
    return this.actualModuleSpecifier;
  }
  
  @Pure
  public List<ImportAssignment> getVariableSTE_actualName() {
    return this.variableSTE_actualName;
  }
  
  @Pure
  public ImportDeclaration getToBeReplacedImportDeclaration() {
    return this.toBeReplacedImportDeclaration;
  }
}
