/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform.internal;

import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.transpiler.es.transform.internal.ImportAssignment;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public class NamedImportAssignment extends ImportAssignment {
  private final String actualName;
  
  private final NamedImportSpecifier toBeReplacedImportSpecifier;
  
  public NamedImportAssignment(final SymbolTableEntryOriginal ste, final String actualName, final NamedImportSpecifier toBeReplacedImportSpecifier) {
    super(ste);
    this.actualName = actualName;
    this.toBeReplacedImportSpecifier = toBeReplacedImportSpecifier;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = super.hashCode();
    result = prime * result + ((this.actualName== null) ? 0 : this.actualName.hashCode());
    result = prime * result + ((this.toBeReplacedImportSpecifier== null) ? 0 : this.toBeReplacedImportSpecifier.hashCode());
    return result;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    if (!super.equals(obj))
      return false;
    NamedImportAssignment other = (NamedImportAssignment) obj;
    if (this.actualName == null) {
      if (other.actualName != null)
        return false;
    } else if (!this.actualName.equals(other.actualName))
      return false;
    if (this.toBeReplacedImportSpecifier == null) {
      if (other.toBeReplacedImportSpecifier != null)
        return false;
    } else if (!this.toBeReplacedImportSpecifier.equals(other.toBeReplacedImportSpecifier))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    String result = new ToStringBuilder(this)
    	.addAllFields()
    	.toString();
    return result;
  }
  
  @Pure
  public String getActualName() {
    return this.actualName;
  }
  
  @Pure
  public NamedImportSpecifier getToBeReplacedImportSpecifier() {
    return this.toBeReplacedImportSpecifier;
  }
}
