/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.impl;

import com.google.common.base.Objects;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.xcore.lib.XcoreEListExtensions;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMemberWithAccessModifier;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.impl.TFunctionImpl;
import org.eclipse.n4js.ts.types.util.AccessModifiers;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TMethodImpl
extends TFunctionImpl
implements TMethod {
    protected static final boolean DECLARED_FINAL_EDEFAULT = false;
    protected boolean declaredFinal = false;
    protected static final boolean DECLARED_STATIC_EDEFAULT = false;
    protected boolean declaredStatic = false;
    protected static final boolean DECLARED_OVERRIDE_EDEFAULT = false;
    protected boolean declaredOverride = false;
    protected static final boolean HAS_COMPUTED_NAME_EDEFAULT = false;
    protected boolean hasComputedName = false;
    protected EList<TMember> constituentMembers;
    protected static final boolean COMPOSED_EDEFAULT = false;
    protected boolean composed = false;
    protected static final boolean HAS_NO_BODY_EDEFAULT = false;
    protected boolean hasNoBody = false;
    protected static final MemberAccessModifier DECLARED_MEMBER_ACCESS_MODIFIER_EDEFAULT = MemberAccessModifier.UNDEFINED;
    protected MemberAccessModifier declaredMemberAccessModifier = DECLARED_MEMBER_ACCESS_MODIFIER_EDEFAULT;
    protected static final boolean DECLARED_ABSTRACT_EDEFAULT = false;
    protected boolean declaredAbstract = false;
    protected static final boolean LACKS_THIS_OR_SUPER_USAGE_EDEFAULT = false;
    protected boolean lacksThisOrSuperUsage = false;

    protected TMethodImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypesPackage.Literals.TMETHOD;
    }

    @Override
    public boolean isDeclaredFinal() {
        return this.declaredFinal;
    }

    @Override
    public void setDeclaredFinal(boolean newDeclaredFinal) {
        boolean oldDeclaredFinal = this.declaredFinal;
        this.declaredFinal = newDeclaredFinal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldDeclaredFinal, this.declaredFinal));
        }
    }

    @Override
    public boolean isDeclaredStatic() {
        return this.declaredStatic;
    }

    @Override
    public void setDeclaredStatic(boolean newDeclaredStatic) {
        boolean oldDeclaredStatic = this.declaredStatic;
        this.declaredStatic = newDeclaredStatic;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldDeclaredStatic, this.declaredStatic));
        }
    }

    @Override
    public boolean isDeclaredOverride() {
        return this.declaredOverride;
    }

    @Override
    public void setDeclaredOverride(boolean newDeclaredOverride) {
        boolean oldDeclaredOverride = this.declaredOverride;
        this.declaredOverride = newDeclaredOverride;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldDeclaredOverride, this.declaredOverride));
        }
    }

    @Override
    public boolean isHasComputedName() {
        return this.hasComputedName;
    }

    @Override
    public void setHasComputedName(boolean newHasComputedName) {
        boolean oldHasComputedName = this.hasComputedName;
        this.hasComputedName = newHasComputedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, oldHasComputedName, this.hasComputedName));
        }
    }

    @Override
    public EList<TMember> getConstituentMembers() {
        if (this.constituentMembers == null) {
            this.constituentMembers = new EObjectResolvingEList(TMember.class, (InternalEObject)this, 20);
        }
        return this.constituentMembers;
    }

    @Override
    public boolean isComposed() {
        return this.composed;
    }

    @Override
    public void setComposed(boolean newComposed) {
        boolean oldComposed = this.composed;
        this.composed = newComposed;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, oldComposed, this.composed));
        }
    }

    @Override
    public boolean isHasNoBody() {
        return this.hasNoBody;
    }

    @Override
    public void setHasNoBody(boolean newHasNoBody) {
        boolean oldHasNoBody = this.hasNoBody;
        this.hasNoBody = newHasNoBody;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, oldHasNoBody, this.hasNoBody));
        }
    }

    @Override
    public MemberAccessModifier getDeclaredMemberAccessModifier() {
        return this.declaredMemberAccessModifier;
    }

    @Override
    public void setDeclaredMemberAccessModifier(MemberAccessModifier newDeclaredMemberAccessModifier) {
        MemberAccessModifier oldDeclaredMemberAccessModifier = this.declaredMemberAccessModifier;
        MemberAccessModifier memberAccessModifier = this.declaredMemberAccessModifier = newDeclaredMemberAccessModifier == null ? DECLARED_MEMBER_ACCESS_MODIFIER_EDEFAULT : newDeclaredMemberAccessModifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldDeclaredMemberAccessModifier, (Object)this.declaredMemberAccessModifier));
        }
    }

    @Override
    public boolean isDeclaredAbstract() {
        return this.declaredAbstract;
    }

    @Override
    public void setDeclaredAbstract(boolean newDeclaredAbstract) {
        boolean oldDeclaredAbstract = this.declaredAbstract;
        this.declaredAbstract = newDeclaredAbstract;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, oldDeclaredAbstract, this.declaredAbstract));
        }
    }

    @Override
    public boolean isLacksThisOrSuperUsage() {
        return this.lacksThisOrSuperUsage;
    }

    @Override
    public void setLacksThisOrSuperUsage(boolean newLacksThisOrSuperUsage) {
        boolean oldLacksThisOrSuperUsage = this.lacksThisOrSuperUsage;
        this.lacksThisOrSuperUsage = newLacksThisOrSuperUsage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, oldLacksThisOrSuperUsage, this.lacksThisOrSuperUsage));
        }
    }

    @Override
    public boolean isAbstract() {
        return this.isDeclaredAbstract() || this.eContainer() instanceof TInterface && this.isHasNoBody();
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.METHOD;
    }

    @Override
    public boolean isConstructor() {
        return Objects.equal((Object)this.getName(), (Object)"constructor") && !this.isStatic();
    }

    @Override
    public String getFunctionAsString() {
        boolean _isReturnValueOptional;
        boolean _tripleNotEquals;
        boolean _isDeclaredAsync;
        StringBuilder strb = new StringBuilder();
        boolean _isGeneric = this.isGeneric();
        if (_isGeneric) {
            Functions.Function1<TypeVariable, String> _function = new Functions.Function1<TypeVariable, String>(){

                public String apply(TypeVariable it) {
                    return it.getTypeAsString();
                }
            };
            strb.append("<").append(IterableExtensions.join((Iterable)XcoreEListExtensions.map(this.getTypeVars(), (Functions.Function1)_function), (CharSequence)",")).append("> ");
        }
        if (_isDeclaredAsync = this.isDeclaredAsync()) {
            strb.append("async ");
        }
        Functions.Function1<TFormalParameter, String> _function_1 = new Functions.Function1<TFormalParameter, String>(){

            public String apply(TFormalParameter it) {
                return it.getFormalParameterAsString();
            }
        };
        strb.append(this.getName()).append("(").append(IterableExtensions.join((Iterable)XcoreEListExtensions.map(this.getFpars(), (Functions.Function1)_function_1), (CharSequence)", ")).append(")");
        TypeRef _returnTypeRef = this.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            strb.append(": ").append(this.getReturnTypeRef().getTypeRefAsString());
        }
        if (_isReturnValueOptional = this.isReturnValueOptional()) {
            strb.append("?");
        }
        return strb.toString();
    }

    @Override
    public String getMemberAsString() {
        return this.getFunctionAsString();
    }

    @Override
    public MemberAccessModifier getMemberAccessModifier() {
        boolean _tripleEquals;
        MemberAccessModifier _declaredMemberAccessModifier = this.getDeclaredMemberAccessModifier();
        boolean bl = _tripleEquals = _declaredMemberAccessModifier == MemberAccessModifier.UNDEFINED;
        if (_tripleEquals) {
            MemberAccessModifier modifierDerivedFromType;
            EObject parent = this.eContainer();
            if (parent instanceof TInterface && (modifierDerivedFromType = AccessModifiers.toMemberModifier(((Type)parent).getTypeAccessModifier())) != MemberAccessModifier.PRIVATE) {
                return modifierDerivedFromType;
            }
            return MemberAccessModifier.PROJECT;
        }
        return this.getDeclaredMemberAccessModifier();
    }

    @Override
    public ContainerType<?> getContainingType() {
        EObject myContainer = this.eContainer();
        ContainerType _xifexpression = null;
        _xifexpression = myContainer instanceof ContainerType ? (ContainerType)myContainer : null;
        return _xifexpression;
    }

    @Override
    public boolean isField() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.FIELD));
    }

    @Override
    public boolean isGetter() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.GETTER));
    }

    @Override
    public boolean isSetter() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.SETTER));
    }

    @Override
    public boolean isAccessor() {
        return Objects.equal((Object)((Object)this.getMemberType()), (Object)((Object)MemberType.SETTER)) || Objects.equal((Object)((Object)this.getMemberType()), (Object)((Object)MemberType.GETTER));
    }

    @Override
    public boolean isMethod() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.METHOD));
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return this.isDeclaredFinal();
    }

    @Override
    public boolean isStatic() {
        return this.isDeclaredStatic();
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isPolyfilled() {
        ContainerType<?> containingType = this.getContainingType();
        if (containingType == null) {
            return false;
        }
        return containingType.isPolyfill() || containingType.isStaticPolyfill();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.isDeclaredFinal();
            }
            case 17: {
                return this.isDeclaredStatic();
            }
            case 18: {
                return this.isDeclaredOverride();
            }
            case 19: {
                return this.isHasComputedName();
            }
            case 20: {
                return this.getConstituentMembers();
            }
            case 21: {
                return this.isComposed();
            }
            case 22: {
                return this.isHasNoBody();
            }
            case 23: {
                return this.getDeclaredMemberAccessModifier();
            }
            case 24: {
                return this.isDeclaredAbstract();
            }
            case 25: {
                return this.isLacksThisOrSuperUsage();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setDeclaredFinal((Boolean)newValue);
                return;
            }
            case 17: {
                this.setDeclaredStatic((Boolean)newValue);
                return;
            }
            case 18: {
                this.setDeclaredOverride((Boolean)newValue);
                return;
            }
            case 19: {
                this.setHasComputedName((Boolean)newValue);
                return;
            }
            case 20: {
                this.getConstituentMembers().clear();
                this.getConstituentMembers().addAll((Collection)newValue);
                return;
            }
            case 21: {
                this.setComposed((Boolean)newValue);
                return;
            }
            case 22: {
                this.setHasNoBody((Boolean)newValue);
                return;
            }
            case 23: {
                this.setDeclaredMemberAccessModifier((MemberAccessModifier)((Object)newValue));
                return;
            }
            case 24: {
                this.setDeclaredAbstract((Boolean)newValue);
                return;
            }
            case 25: {
                this.setLacksThisOrSuperUsage((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setDeclaredFinal(false);
                return;
            }
            case 17: {
                this.setDeclaredStatic(false);
                return;
            }
            case 18: {
                this.setDeclaredOverride(false);
                return;
            }
            case 19: {
                this.setHasComputedName(false);
                return;
            }
            case 20: {
                this.getConstituentMembers().clear();
                return;
            }
            case 21: {
                this.setComposed(false);
                return;
            }
            case 22: {
                this.setHasNoBody(false);
                return;
            }
            case 23: {
                this.setDeclaredMemberAccessModifier(DECLARED_MEMBER_ACCESS_MODIFIER_EDEFAULT);
                return;
            }
            case 24: {
                this.setDeclaredAbstract(false);
                return;
            }
            case 25: {
                this.setLacksThisOrSuperUsage(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.declaredFinal;
            }
            case 17: {
                return this.declaredStatic;
            }
            case 18: {
                return this.declaredOverride;
            }
            case 19: {
                return this.hasComputedName;
            }
            case 20: {
                return this.constituentMembers != null && !this.constituentMembers.isEmpty();
            }
            case 21: {
                return this.composed;
            }
            case 22: {
                return this.hasNoBody;
            }
            case 23: {
                return this.declaredMemberAccessModifier != DECLARED_MEMBER_ACCESS_MODIFIER_EDEFAULT;
            }
            case 24: {
                return this.declaredAbstract;
            }
            case 25: {
                return this.lacksThisOrSuperUsage;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == TMember.class) {
            switch (derivedFeatureID) {
                case 16: {
                    return 3;
                }
                case 17: {
                    return 4;
                }
                case 18: {
                    return 5;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 8;
                }
            }
            return -1;
        }
        if (baseClass == TMemberWithAccessModifier.class) {
            switch (derivedFeatureID) {
                case 22: {
                    return 9;
                }
                case 23: {
                    return 10;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == TMember.class) {
            switch (baseFeatureID) {
                case 3: {
                    return 16;
                }
                case 4: {
                    return 17;
                }
                case 5: {
                    return 18;
                }
                case 6: {
                    return 19;
                }
                case 7: {
                    return 20;
                }
                case 8: {
                    return 21;
                }
            }
            return -1;
        }
        if (baseClass == TMemberWithAccessModifier.class) {
            switch (baseFeatureID) {
                case 9: {
                    return 22;
                }
                case 10: {
                    return 23;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == Type.class) {
            switch (baseOperationID) {
                case 6: {
                    return 39;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == TFunction.class) {
            switch (baseOperationID) {
                case 23: {
                    return 47;
                }
                case 24: {
                    return 39;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == TMember.class) {
            switch (baseOperationID) {
                case 1: {
                    return 25;
                }
                case 2: {
                    return 43;
                }
                case 3: {
                    return 45;
                }
                case 4: {
                    return 28;
                }
                case 5: {
                    return 29;
                }
                case 6: {
                    return 30;
                }
                case 7: {
                    return 31;
                }
                case 8: {
                    return 32;
                }
                case 9: {
                    return 46;
                }
                case 10: {
                    return 34;
                }
                case 11: {
                    return 44;
                }
                case 12: {
                    return 36;
                }
                case 13: {
                    return 37;
                }
                case 14: {
                    return 48;
                }
                case 15: {
                    return 39;
                }
                case 16: {
                    return 40;
                }
                case 17: {
                    return 41;
                }
                case 18: {
                    return 42;
                }
            }
            return -1;
        }
        if (baseClass == TMemberWithAccessModifier.class) {
            switch (baseOperationID) {
                case 19: {
                    return 43;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 44: {
                return this.isAbstract();
            }
            case 45: {
                return this.getMemberType();
            }
            case 46: {
                return this.isConstructor();
            }
            case 47: {
                return this.getFunctionAsString();
            }
            case 48: {
                return this.getMemberAsString();
            }
            case 43: {
                return this.getMemberAccessModifier();
            }
            case 25: {
                return this.getContainingType();
            }
            case 28: {
                return this.isField();
            }
            case 29: {
                return this.isGetter();
            }
            case 30: {
                return this.isSetter();
            }
            case 31: {
                return this.isAccessor();
            }
            case 32: {
                return this.isMethod();
            }
            case 34: {
                return this.isOptional();
            }
            case 36: {
                return this.isReadable();
            }
            case 37: {
                return this.isWriteable();
            }
            case 39: {
                return this.isFinal();
            }
            case 40: {
                return this.isStatic();
            }
            case 41: {
                return this.isConst();
            }
            case 42: {
                return this.isPolyfilled();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (declaredFinal: ");
        result.append(this.declaredFinal);
        result.append(", declaredStatic: ");
        result.append(this.declaredStatic);
        result.append(", declaredOverride: ");
        result.append(this.declaredOverride);
        result.append(", hasComputedName: ");
        result.append(this.hasComputedName);
        result.append(", composed: ");
        result.append(this.composed);
        result.append(", hasNoBody: ");
        result.append(this.hasNoBody);
        result.append(", declaredMemberAccessModifier: ");
        result.append((Object)this.declaredMemberAccessModifier);
        result.append(", declaredAbstract: ");
        result.append(this.declaredAbstract);
        result.append(", lacksThisOrSuperUsage: ");
        result.append(this.lacksThisOrSuperUsage);
        result.append(')');
        return result.toString();
    }
}

