/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.ui.external.ExternalLibraryBuildQueue;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;

@Singleton
public class ExternalLibraryBuildScheduler {
    private final ExternalLibraryBuilder builderHelper;
    private final ExternalLibraryBuildQueue builderQueue;
    private final ExternalLibraryBuildJob buildJob;

    @Inject
    public ExternalLibraryBuildScheduler(ExternalLibraryBuilder builderHelper, ExternalLibraryBuildQueue builderQueue) {
        this.builderHelper = builderHelper;
        this.builderQueue = builderQueue;
        this.buildJob = new ExternalLibraryBuildJob(builderHelper);
    }

    public void scheduleBuildJob(Collection<N4JSExternalProject> toBuild, Collection<N4JSExternalProject> toClean) {
        this.builderQueue.enqueue(toBuild, toClean);
        this.buildJob.schedule();
    }

    public void buildExternalProjectsNow(IProgressMonitor monitor) {
        this.builderHelper.process(this.builderQueue.exhaust(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinBuildJob() {
        try {
            ExternalLibraryBuildScheduler externalLibraryBuildScheduler = this;
            synchronized (externalLibraryBuildScheduler) {
                this.wait(1L);
            }
            this.buildJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class ExternalLibraryBuildJob
    extends WorkspaceJob {
        private ExternalLibraryBuildJob(ExternalLibraryBuilder builderHelper) {
            super("External library build");
            this.setSystem(true);
            this.setRule(builderHelper.getRule());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ExternalLibraryBuildScheduler.this.buildExternalProjectsNow(monitor);
            return Status.OK_STATUS;
        }
    }
}

