/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ui.internal.EclipseBasedN4JSWorkspace;
import org.eclipse.n4js.ui.internal.EclipseSourceContainer;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseSourceContainer;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;

@Singleton
public class N4JSEclipseModel
extends N4JSModel {
    private static final Logger LOGGER = Logger.getLogger(N4JSEclipseModel.class);
    private final IWorkspaceRoot workspace;

    @Inject
    public N4JSEclipseModel(EclipseBasedN4JSWorkspace workspace) {
        super((InternalN4JSWorkspace)workspace);
        this.workspace = workspace.getWorkspace();
    }

    public N4JSEclipseProject getN4JSProject(URI location) {
        N4JSExternalProject project;
        Preconditions.checkArgument((location.isPlatformResource() || location.isFile() ? 1 : 0) != 0, (Object)("Expected either platform:/resource or file:/ URI. Was: " + location));
        if (location.isPlatformResource() && !URIUtils.isPlatformResourceUriPointingToProject((URI)location)) {
            Preconditions.checkArgument((boolean)URIUtils.isPlatformResourceUriPointingToProject((URI)location), (Object)("Expected 2 segment counts for platform resource URI pointing to a project. Was " + location.segmentCount()));
        }
        String n4jsProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)location);
        if (location.isFile()) {
            String eclipseProjectName;
            project = this.externalLibraryWorkspace.getProject(n4jsProjectName);
            if (project == null && (project = this.workspace.getProject(eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)n4jsProjectName))) != null) {
                return this.getN4JSProject((IProject)project);
            }
            Preconditions.checkNotNull((Object)project, (Object)("Project does not exist in external workspace. URI: " + location));
        } else {
            String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)n4jsProjectName);
            project = this.workspace.getProject(eclipseProjectName);
        }
        return this.doGetN4JSProject((IProject)project, location);
    }

    protected IN4JSProject newAbsentProject(String projectName) {
        URI uri = URI.createPlatformResourceURI((String)projectName, (boolean)false);
        String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)projectName);
        return new N4JSEclipseProject(this.workspace.getProject(eclipseProjectName), uri, this);
    }

    public N4JSEclipseProject findProjectWith(URI nestedLocation) {
        return (N4JSEclipseProject)super.findProjectWith(nestedLocation);
    }

    public Optional<? extends IN4JSSourceContainer> findN4JSSourceContainer(URI location) {
        Optional<? extends IN4JSSourceContainer> n4jsContainer = Optional.absent();
        if (N4Scheme.isN4Scheme((URI)location)) {
            return n4jsContainer;
        }
        if (!location.isPlatformResource()) {
            N4JSEclipseProject eclipseProject;
            if ("revision".equals(location.scheme())) {
                if (LOGGER.isDebugEnabled()) {
                    String message = "Got revision-scheme request, but refuse to find source-container for that:" + location;
                    LOGGER.debug((Object)message);
                }
                return n4jsContainer;
            }
            if (location.isFile() && (eclipseProject = this.findProjectWith(location)) != null && eclipseProject.exists()) {
                if (eclipseProject.getProject() instanceof ExternalProject) {
                    IResource resource = this.externalLibraryWorkspace.getResource(location);
                    if (resource != null) {
                        n4jsContainer = this.getN4JSSourceContainer(resource);
                    }
                } else {
                    String projPathString;
                    String locString = location.toFileString();
                    if (locString.startsWith(projPathString = eclipseProject.getLocationPath().toString())) {
                        locString = String.valueOf(eclipseProject.getLocation().toString()) + locString.substring(projPathString.length());
                    }
                    for (IN4JSEclipseSourceContainer sc : eclipseProject.getSourceContainers()) {
                        String scLoc = sc.getLocation().toString();
                        if (!locString.startsWith(scLoc)) continue;
                        return Optional.of((Object)sc);
                    }
                }
            }
            return n4jsContainer;
        }
        N4JSEclipseProject project = this.findProjectWith(location);
        if (project != null && project.exists()) {
            Path path = new Path(location.toPlatformString(true));
            Object resource = 1 == path.segmentCount() ? this.workspace.getProject(path.segment(0)) : this.workspace.getFile((IPath)path);
            n4jsContainer = this.getN4JSSourceContainer((IResource)resource);
        }
        return n4jsContainer;
    }

    public N4JSEclipseProject getN4JSProject(IProject project) {
        return this.doGetN4JSProject(project, URIUtils.convert((IResource)project));
    }

    private N4JSEclipseProject doGetN4JSProject(IProject project, URI location) {
        return new N4JSEclipseProject(project, location, this);
    }

    public ImmutableList<? extends IN4JSEclipseSourceContainer> getN4JSSourceContainers(N4JSProject project) {
        ImmutableList.Builder result = ImmutableList.builder();
        URI location = project.getLocation();
        ProjectDescription description = this.getProjectDescription(location);
        if (description != null) {
            ArrayList sourceFragments = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)description.getSourceContainers()));
            sourceFragments.sort((f1, f2) -> ProjectDescriptionUtils.compareBySourceContainerType((SourceContainerDescription)f1, (SourceContainerDescription)f2));
            for (SourceContainerDescription sourceFragment : sourceFragments) {
                List paths = ProjectDescriptionUtils.getPathsNormalized((SourceContainerDescription)sourceFragment);
                for (String p : paths) {
                    IN4JSEclipseSourceContainer sourceContainer = this.createProjectN4JSSourceContainer(project, sourceFragment.getSourceContainerType(), p);
                    result.add((Object)sourceContainer);
                }
            }
        }
        return result.build();
    }

    protected String getLocationPath(URI location) {
        return CommonPlugin.asLocalURI((URI)location).toFileString();
    }

    public ImmutableList<? extends IN4JSEclipseProject> getDependencies(N4JSProject project, boolean includeAbsentProjects) {
        return super.getDependencies(project, includeAbsentProjects);
    }

    public ImmutableList<? extends IN4JSEclipseProject> getDependenciesAndImplementedApis(N4JSProject project, boolean includeAbsentProjects) {
        return super.getDependenciesAndImplementedApis(project, includeAbsentProjects);
    }

    public ImmutableList<? extends IN4JSEclipseProject> getImplementedProjects(N4JSProject project) {
        return super.getImplementedProjects(project);
    }

    protected IN4JSEclipseSourceContainer createProjectN4JSSourceContainer(N4JSProject project, SourceContainerType type, String relativeLocation) {
        N4JSEclipseProject casted = (N4JSEclipseProject)project;
        IProject eclipseProject = casted.getProject();
        String relPath = new Path(relativeLocation).toString();
        Object container = relPath.isEmpty() || ".".equals(relPath) ? eclipseProject : eclipseProject.getFolder(relativeLocation);
        return new EclipseSourceContainer(casted, type, (IContainer)container);
    }

    public Optional<? extends IN4JSSourceContainer> getN4JSSourceContainer(IResource resource) {
        N4JSEclipseProject project = this.getN4JSProject(resource.getProject());
        ImmutableList<? extends IN4JSEclipseSourceContainer> containers = project.getSourceContainers();
        IPath fullPath = resource.getFullPath();
        IN4JSEclipseSourceContainer matchingContainer = null;
        int matchingSegmentCount = -1;
        for (IN4JSEclipseSourceContainer container : containers) {
            int segmentCount;
            if (!this.matchPaths(fullPath, container) || (segmentCount = container.getContainer().getFullPath().segmentCount()) <= matchingSegmentCount) continue;
            matchingContainer = container;
            matchingSegmentCount = segmentCount;
        }
        return Optional.fromNullable(matchingContainer);
    }

    private boolean matchPaths(IPath fullPath, IN4JSEclipseSourceContainer sourceContainer) {
        IContainer container = sourceContainer.getContainer();
        return this.pathStartsWithFolder(fullPath, container);
    }

    private boolean pathStartsWithFolder(IPath fullPath, IContainer container) {
        IPath containerPath = container.getFullPath();
        int maxSegments = containerPath.segmentCount();
        if (fullPath.segmentCount() >= maxSegments) {
            int j = 0;
            while (j < maxSegments) {
                if (!fullPath.segment(j).equals(containerPath.segment(j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public Iterable<IN4JSProject> findAllProjects() {
        return this.findAllProjectMappings().values();
    }

    public Map<String, IN4JSProject> findAllProjectMappings() {
        LinkedHashMap<String, IN4JSProject> workspaceProjectMapping = new LinkedHashMap<String, IN4JSProject>();
        IProject[] iProjectArray = this.workspace.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                N4JSEclipseProject n4jsProject = this.getN4JSProject(project);
                workspaceProjectMapping.put(n4jsProject.getProjectName(), n4jsProject);
            }
            ++n2;
        }
        for (IProject project : this.externalLibraryWorkspace.getProjects()) {
            N4JSEclipseProject n4jsProject = this.getN4JSProject(project);
            if (workspaceProjectMapping.containsKey(n4jsProject.getProjectName())) continue;
            workspaceProjectMapping.put(n4jsProject.getProjectName(), n4jsProject);
        }
        return workspaceProjectMapping;
    }
}

