/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.validation.DefaultResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.MarkerEraser;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ResourceUIValidatorExtension
extends MarkerEraser
implements IResourceUIValidatorExtension {
    private static final Logger LOGGER = Logger.getLogger(DefaultResourceUIValidatorExtension.class);

    public void updateValidationMarkers(IFile file, Resource resource, CheckMode mode, IProgressMonitor monitor) throws OperationCanceledException {
        if (this.shouldProcess(file)) {
            this.addMarkers(file, resource, mode, monitor);
        }
    }

    public void deleteValidationMarkers(IFile file, CheckMode checkMode, IProgressMonitor monitor) {
        super.deleteValidationMarkers(file, checkMode, monitor);
    }

    private void addMarkers(IFile file, Resource resource, CheckMode mode, IProgressMonitor monitor) throws OperationCanceledException {
        try {
            List list = this.getValidator(resource).validate(resource, mode, this.getCancelIndicator(monitor));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.deleteMarkers(file, mode, monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createMarkers(file, list, this.getMarkerCreator(resource), this.getMarkerTypeProvider(resource));
        }
        catch (OperationCanceledError error) {
            throw error.getWrapped();
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void createMarkers(IFile file, List<Issue> list, MarkerCreator markerCreator, MarkerTypeProvider markerTypeProvider) throws CoreException {
        for (Issue issue : list) {
            markerCreator.createMarker(issue, (IResource)file, markerTypeProvider.getMarkerType(issue));
        }
    }

    private CancelIndicator getCancelIndicator(IProgressMonitor monitor) {
        return () -> monitor.isCanceled();
    }

    private IResourceValidator getValidator(Resource resource) {
        return this.getService(resource, IResourceValidator.class);
    }

    private MarkerCreator getMarkerCreator(Resource resource) {
        return this.getService(resource, MarkerCreator.class);
    }

    private MarkerTypeProvider getMarkerTypeProvider(Resource resource) {
        return this.getService(resource, MarkerTypeProvider.class);
    }

    private <T> T getService(Resource resource, Class<T> clazz) {
        IResourceServiceProvider serviceProvider = ((XtextResource)resource).getResourceServiceProvider();
        return (T)serviceProvider.get(clazz);
    }
}

