/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.git;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.n4js.utils.git.SshSessionFactory;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.xtext.xbase.lib.Exceptions;

public abstract class GitUtils {
    private static final Logger LOGGER = Logger.getLogger(GitUtils.class);
    private static final String ORIGIN = "origin";
    private static final TransportConfigCallback TRANSPORT_CALLBACK = transport -> {
        if (transport instanceof SshTransport) {
            ((SshTransport)transport).setSshSessionFactory((org.eclipse.jgit.transport.SshSessionFactory)new SshSessionFactory());
        }
    };

    public static boolean netIsAvailable(String remoteUrl) {
        try {
            URL url = new URL(remoteUrl);
            URLConnection conn = url.openConnection();
            conn.connect();
            return true;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void hardReset(String remoteUri, Path localClonePath, String branch, boolean cloneIfMissing) {
        LOGGER.info((Object)("Performing hard reset... [Local repository: " + localClonePath + ", remote URI: " + remoteUri + ", branch: " + branch + "]"));
        Preconditions.checkNotNull((Object)localClonePath, (Object)"localClonePath");
        if (cloneIfMissing) {
            Preconditions.checkNotNull((Object)remoteUri, (Object)"remoteUri");
            GitUtils.clone(remoteUri, localClonePath, branch);
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (Git git = Git.open((File)localClonePath.toFile());){
                String currentBranch = git.getRepository().getBranch();
                if (!currentBranch.equals(branch)) {
                    LOGGER.info((Object)("Current branch is: '" + currentBranch + "'."));
                    LOGGER.info((Object)("Switching to desired '" + branch + "' branch..."));
                    git.pull().setProgressMonitor((ProgressMonitor)GitUtils.createMonitor()).call();
                    boolean createLocalBranch = !GitUtils.hasLocalBranch(git, branch);
                    LOGGER.info((Object)("Creating local branch '" + branch + "'? --> " + (createLocalBranch ? "yes" : "no")));
                    git.checkout().setCreateBranch(createLocalBranch).setName(branch).setStartPoint("refs/remotes/origin/" + branch).call();
                    Preconditions.checkState((boolean)git.getRepository().getBranch().equals(branch), (Object)("Error when checking out '" + branch + "' branch."));
                    LOGGER.info((Object)("Switched to '" + branch + "' branch."));
                    git.pull().setProgressMonitor((ProgressMonitor)GitUtils.createMonitor()).call();
                }
                LOGGER.info((Object)("Hard resetting local repository HEAD of the '" + branch + "' in '" + remoteUri + "'..."));
                LOGGER.info((Object)("Local repository location: " + localClonePath + "."));
                ResetCommand resetCommand = git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD");
                Ref ref = resetCommand.call();
                LOGGER.info((Object)("Repository content has been successfully reset to '" + ref + "'."));
                Set deletedFiles = git.clean().setCleanDirectories(true).call();
                LOGGER.info((Object)("Cleaned up " + deletedFiles.size() + " files:\n" + Joiner.on((String)",\n").join((Iterable)deletedFiles)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RepositoryNotFoundException e) {
            if (cloneIfMissing) {
                Throwables.propagate((Throwable)e);
            }
            String message = "Git repository does not exist at " + localClonePath + ". Git repository should be cloned manually.";
            throw new RuntimeException(message, e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error when trying to hard reset to HEAD on '" + branch + "' branch in " + localClonePath + " repository."));
            Throwables.propagate((Throwable)e);
        }
    }

    public static void hardReset(Iterable<String> remoteUris, Iterable<Path> localClonePaths, String branch, boolean cloneIfMissing) {
        Preconditions.checkNotNull(remoteUris, (Object)"remoteUris");
        Preconditions.checkNotNull(localClonePaths, (Object)"localClonePaths");
        Preconditions.checkArgument((Iterables.size(remoteUris) == Iterables.size(localClonePaths) ? 1 : 0) != 0, (Object)"Remote URI - local clone path mismatch.");
        Path[] paths = (Path[])Iterables.toArray(localClonePaths, Path.class);
        int i = 0;
        CountDownLatch latch = new CountDownLatch(Iterables.size(remoteUris));
        AtomicReference resetExc = new AtomicReference();
        Object mutex = new Object();
        for (String remoteUri : remoteUris) {
            int pathIndex = i++;
            new Thread(() -> {
                try {
                    try {
                        GitUtils.hardReset(remoteUri, paths[pathIndex], branch, cloneIfMissing);
                    }
                    catch (Exception e) {
                        if (resetExc.get() == null) {
                            Object object2 = mutex;
                            synchronized (object2) {
                                if (resetExc.get() == null) {
                                    resetExc.set(e);
                                }
                            }
                        }
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            }, "Thread-Git-Hard-Reset-" + remoteUri).start();
        }
        try {
            latch.await(5L, TimeUnit.MINUTES);
            if (resetExc.get() != null) {
                Exceptions.sneakyThrow((Throwable)((Throwable)resetExc.get()));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Timeouted while checking out remote Git repositories: " + Iterables.toString(remoteUris), e);
        }
    }

    public static void pull(Path localClonePath) {
        GitUtils.pull(localClonePath, null);
    }

    public static void pull(Path localClonePath, IProgressMonitor monitor) {
        TextProgressMonitor gitMonitor;
        Object object = gitMonitor = monitor == null ? GitUtils.createMonitor() : new EclipseGitProgressTransformer(monitor);
        if (localClonePath == null) {
            LOGGER.warn((Object)"Local clone path should be specified for the git clone operation.");
            return;
        }
        File localCloneRoot = localClonePath.toFile();
        if (!localCloneRoot.exists()) {
            LOGGER.warn((Object)("Local git repository clone root does not exist: " + localCloneRoot + "."));
            return;
        }
        if (!localCloneRoot.isDirectory()) {
            LOGGER.warn((Object)("Expecting a directory as the local git repository clone. Was a file: " + localCloneRoot + "."));
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (Git git = Git.open((File)localCloneRoot);){
                ((PullCommand)git.pull().setProgressMonitor((ProgressMonitor)gitMonitor).setTransportConfigCallback(TRANSPORT_CALLBACK)).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            LOGGER.error((Object)("Error when trying to pull on repository  '" + localClonePath + "."));
            Throwables.propagate((Throwable)e);
        }
        catch (RepositoryNotFoundException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Git repository does not exists at " + localCloneRoot + ". Aborting git pull."));
            LOGGER.warn((Object)"Perform git clone first, then try to pull from remote.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)("Error when trying to open repository  '" + localClonePath + "."));
            }
            Throwables.propagate((Throwable)e);
        }
    }

    public static String getMasterBranch() {
        return "master";
    }

    private static void clone(String remoteUri, Path localClonePath, String branch) {
        Preconditions.checkNotNull((Object)remoteUri, (Object)"remoteUri");
        Preconditions.checkNotNull((Object)localClonePath, (Object)"clonePath");
        Preconditions.checkNotNull((Object)branch, (Object)"branch");
        File destinationFolder = localClonePath.toFile();
        if (!destinationFolder.exists()) {
            try {
                Files.createDirectories(localClonePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String message = "Error while creating directory for local repository under " + localClonePath + ".";
                LOGGER.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
            LOGGER.info((Object)("Creating folder for repository at '" + localClonePath + "'."));
        }
        Preconditions.checkState((boolean)destinationFolder.exists(), (Object)("Repository folder does not exist folder does not exist: " + destinationFolder.getAbsolutePath()));
        Object[] existingFiles = destinationFolder.listFiles();
        if (!Arrays2.isEmpty(existingFiles)) {
            try {
                Throwable message = null;
                Object var6_11 = null;
                try (Git git22 = Git.open((File)localClonePath.toFile());){
                    LOGGER.info((Object)("Repository already exists. Aborting clone phase. Files in " + destinationFolder + " are: " + Joiner.on((char)',').join(existingFiles)));
                    List<URIish> originUris = GitUtils.getOriginUris(git22);
                    if (!GitUtils.hasRemote(originUris, remoteUri)) {
                        LOGGER.info((Object)("Desired remote URI differs from the current one. Desired: '" + remoteUri + "' origin URIs: '" + Joiner.on((char)',').join(originUris) + "'."));
                        LOGGER.info((Object)"Cleaning up current git clone and running clone phase from scratch.");
                        GitUtils.deleteRecursively(destinationFolder);
                        GitUtils.clone(remoteUri, localClonePath, branch);
                    } else {
                        String currentBranch = git22.getRepository().getBranch();
                        if (!currentBranch.equals(branch)) {
                            LOGGER.info((Object)("Desired branch differs from the current one. Desired: '" + branch + "' current: '" + currentBranch + "'."));
                            git22.pull().setProgressMonitor((ProgressMonitor)GitUtils.createMonitor()).call();
                            Ref remoteBranchRef = (Ref)FluentIterable.from((Iterable)git22.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call()).firstMatch(ref -> ref.getName().equals("refs/remotes/origin/" + branch)).orNull();
                            if (remoteBranchRef == null) {
                                LOGGER.info((Object)"Cleaning up current git clone and running clone phase from scratch.");
                                GitUtils.deleteRecursively(destinationFolder);
                                GitUtils.clone(remoteUri, localClonePath, currentBranch);
                            } else {
                                git22.pull().setProgressMonitor((ProgressMonitor)GitUtils.createMonitor()).call();
                                LOGGER.info((Object)"Pulled from upstream.");
                            }
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (message == null) {
                        message = throwable;
                    } else if (message != throwable) {
                        message.addSuppressed(throwable);
                    }
                    throw message;
                }
            }
            catch (Exception e) {
                String msg = "Error when performing git pull in " + localClonePath + " from " + remoteUri + ".";
                LOGGER.error((Object)msg, (Throwable)e);
                throw new RuntimeException("Error when performing git pull in " + localClonePath + " from " + remoteUri + ".", e);
            }
        }
        LOGGER.info((Object)("Cloning repository from '" + remoteUri + "'..."));
        CloneCommand cloneCommand = (CloneCommand)Git.cloneRepository().setURI(remoteUri).setDirectory(destinationFolder).setBranch(branch).setProgressMonitor((ProgressMonitor)GitUtils.createMonitor()).setTransportConfigCallback(TRANSPORT_CALLBACK);
        try {
            Throwable msg = null;
            Object git22 = null;
            try (Git git = cloneCommand.call();){
                LOGGER.info((Object)("Repository content has been successfully cloned to '" + git.getRepository().getDirectory() + "'."));
            }
            catch (Throwable git22) {
                if (msg == null) {
                    msg = git22;
                } else if (msg != git22) {
                    msg.addSuppressed(git22);
                }
                throw msg;
            }
        }
        catch (GitAPIException e) {
            String message = "Error while cloning repository.";
            LOGGER.error((Object)"Error while cloning repository.", (Throwable)e);
            LOGGER.info((Object)("Trying to clean up local repository content: " + destinationFolder + "."));
            GitUtils.deleteRecursively(destinationFolder);
            LOGGER.info((Object)"Inconsistent checkout directory was successfully cleaned up.");
            throw new RuntimeException("Error while cloning repository.", e);
        }
    }

    private static boolean hasLocalBranch(Git git, String branchName) throws GitAPIException {
        List localBranchRefs = git.branchList().call();
        return FluentIterable.from((Iterable)localBranchRefs).anyMatch(ref -> ref.getName().endsWith(branchName));
    }

    private static boolean hasRemote(Iterable<URIish> uris, String uriStr) throws URISyntaxException {
        URIish uri = new URIish(uriStr);
        return FluentIterable.from(uris).anyMatch(originUri -> GitUtils.equals(originUri, uri));
    }

    private static boolean equals(URIish lhs, URIish rhs) {
        if (!(StringUtils.isEmptyOrNull((String)lhs.getScheme()) || StringUtils.isEmptyOrNull((String)rhs.getScheme()) || Objects.equals(lhs.getScheme(), rhs.getScheme()))) {
            return false;
        }
        if (!GitUtils.equals(lhs.getUser(), rhs.getUser())) {
            return false;
        }
        if (!GitUtils.equals(lhs.getPass(), rhs.getPass())) {
            return false;
        }
        if (!GitUtils.equals(lhs.getHost(), rhs.getHost())) {
            return false;
        }
        if (lhs.getPort() != rhs.getPort()) {
            return false;
        }
        return GitUtils.pathEquals(lhs.getPath(), rhs.getPath());
    }

    private static boolean equals(String lhs, String rhs) {
        if (StringUtils.isEmptyOrNull((String)lhs) && StringUtils.isEmptyOrNull((String)rhs)) {
            return true;
        }
        return Objects.equals(lhs, rhs);
    }

    private static boolean pathEquals(String lhs, String rhs) {
        if (StringUtils.isEmptyOrNull((String)lhs) && StringUtils.isEmptyOrNull((String)rhs)) {
            return true;
        }
        int lhsIndex = 0;
        while (lhsIndex < lhs.length() && lhs.charAt(lhsIndex) == '/') {
            ++lhsIndex;
        }
        int rhsIndex = 0;
        while (rhsIndex < rhs.length() && rhs.charAt(rhsIndex) == '/') {
            ++rhsIndex;
        }
        String lhsRel = lhs.substring(lhsIndex);
        String rhsRel = rhs.substring(rhsIndex);
        return lhsRel.equals(rhsRel);
    }

    private static List<URIish> getOriginUris(Git git) throws GitAPIException {
        Optional<RemoteConfig> origin = GitUtils.getOriginRemote(git);
        if (origin.isPresent()) {
            return ((RemoteConfig)origin.get()).getURIs();
        }
        return Collections.emptyList();
    }

    private static Optional<RemoteConfig> getOriginRemote(Git git) throws GitAPIException {
        List remotes = git.remoteList().call();
        if (remotes.isEmpty()) {
            return Optional.absent();
        }
        String origin = GitUtils.getDefaultRemote();
        return FluentIterable.from((Iterable)remotes).firstMatch(remote -> remote.getName().equals(origin));
    }

    public static String getDefaultRemote() {
        return ORIGIN;
    }

    private static TextProgressMonitor createMonitor() {
        return new TextProgressMonitor((Writer)new OutputStreamWriter(System.out));
    }

    private static void deleteRecursively(File file) {
        try {
            FileDeleter.delete(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while recursively cleaning up content of " + file + ".");
        }
    }
}

